// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutResourcePolicyRequest private constructor(builder: Builder) {
    /**
     * A flag to indicate whether to bypass the resource policy lockout safety check.
     *
     * Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately.
     *
     * Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent `PutResourcePolicy` request.
     *
     * The default value is false.
     */
    public val bypassPolicyLockoutCheck: kotlin.Boolean? = builder.bypassPolicyLockoutCheck
    /**
     * The resource policy document, which can be up to 5kb in size.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * The name of the resource policy. Must be unique within a specific Amazon Web Services account.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account.
     *
     * If the policy revision id does not match the latest revision id, the operation will fail with an `InvalidPolicyRevisionIdException` exception. You can also provide a `PolicyRevisionId` of 0. In this case, the operation will fail with an `InvalidPolicyRevisionIdException` exception if a resource policy with the same name already exists.
     */
    public val policyRevisionId: kotlin.String? = builder.policyRevisionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.PutResourcePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutResourcePolicyRequest(")
        append("bypassPolicyLockoutCheck=$bypassPolicyLockoutCheck,")
        append("policyDocument=$policyDocument,")
        append("policyName=$policyName,")
        append("policyRevisionId=$policyRevisionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassPolicyLockoutCheck?.hashCode() ?: 0
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyRevisionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutResourcePolicyRequest

        if (bypassPolicyLockoutCheck != other.bypassPolicyLockoutCheck) return false
        if (policyDocument != other.policyDocument) return false
        if (policyName != other.policyName) return false
        if (policyRevisionId != other.policyRevisionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.PutResourcePolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag to indicate whether to bypass the resource policy lockout safety check.
         *
         * Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true indiscriminately.
         *
         * Use this parameter only when you include a policy in the request and you intend to prevent the principal that is making the request from making a subsequent `PutResourcePolicy` request.
         *
         * The default value is false.
         */
        public var bypassPolicyLockoutCheck: kotlin.Boolean? = null
        /**
         * The resource policy document, which can be up to 5kb in size.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * The name of the resource policy. Must be unique within a specific Amazon Web Services account.
         */
        public var policyName: kotlin.String? = null
        /**
         * Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is created if it does not exist, or updated with an incremented revision id. The revision id is unique to each policy in the account.
         *
         * If the policy revision id does not match the latest revision id, the operation will fail with an `InvalidPolicyRevisionIdException` exception. You can also provide a `PolicyRevisionId` of 0. In this case, the operation will fail with an `InvalidPolicyRevisionIdException` exception if a resource policy with the same name already exists.
         */
        public var policyRevisionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.PutResourcePolicyRequest) : this() {
            this.bypassPolicyLockoutCheck = x.bypassPolicyLockoutCheck
            this.policyDocument = x.policyDocument
            this.policyName = x.policyName
            this.policyRevisionId = x.policyRevisionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.PutResourcePolicyRequest = PutResourcePolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
