// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A configuration document that specifies encryption configuration settings.
 */
public class EncryptionConfig private constructor(builder: Builder) {
    /**
     * The ID of the KMS key used for encryption, if applicable.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The encryption status. While the status is `UPDATING`, X-Ray may encrypt data with a combination of the new and old settings.
     */
    public val status: aws.sdk.kotlin.services.xray.model.EncryptionStatus? = builder.status
    /**
     * The type of encryption. Set to `KMS` for encryption with KMS keys. Set to `NONE` for default encryption.
     */
    public val type: aws.sdk.kotlin.services.xray.model.EncryptionType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.xray.model.EncryptionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionConfig(")
        append("keyId=$keyId,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionConfig

        if (keyId != other.keyId) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.xray.model.EncryptionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the KMS key used for encryption, if applicable.
         */
        public var keyId: kotlin.String? = null
        /**
         * The encryption status. While the status is `UPDATING`, X-Ray may encrypt data with a combination of the new and old settings.
         */
        public var status: aws.sdk.kotlin.services.xray.model.EncryptionStatus? = null
        /**
         * The type of encryption. Set to `KMS` for encryption with KMS keys. Set to `NONE` for default encryption.
         */
        public var type: aws.sdk.kotlin.services.xray.model.EncryptionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.xray.model.EncryptionConfig) : this() {
            this.keyId = x.keyId
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.xray.model.EncryptionConfig = EncryptionConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
