// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.xray

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.xray.auth.DefaultXRayAuthSchemeProvider
import aws.sdk.kotlin.services.xray.auth.XRayAuthSchemeProvider
import aws.sdk.kotlin.services.xray.endpoints.DefaultXRayEndpointProvider
import aws.sdk.kotlin.services.xray.endpoints.XRayEndpointParameters
import aws.sdk.kotlin.services.xray.endpoints.XRayEndpointProvider
import aws.sdk.kotlin.services.xray.model.BatchGetTracesRequest
import aws.sdk.kotlin.services.xray.model.BatchGetTracesResponse
import aws.sdk.kotlin.services.xray.model.CreateGroupRequest
import aws.sdk.kotlin.services.xray.model.CreateGroupResponse
import aws.sdk.kotlin.services.xray.model.CreateSamplingRuleRequest
import aws.sdk.kotlin.services.xray.model.CreateSamplingRuleResponse
import aws.sdk.kotlin.services.xray.model.DeleteGroupRequest
import aws.sdk.kotlin.services.xray.model.DeleteGroupResponse
import aws.sdk.kotlin.services.xray.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.xray.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.xray.model.DeleteSamplingRuleRequest
import aws.sdk.kotlin.services.xray.model.DeleteSamplingRuleResponse
import aws.sdk.kotlin.services.xray.model.GetEncryptionConfigRequest
import aws.sdk.kotlin.services.xray.model.GetEncryptionConfigResponse
import aws.sdk.kotlin.services.xray.model.GetGroupRequest
import aws.sdk.kotlin.services.xray.model.GetGroupResponse
import aws.sdk.kotlin.services.xray.model.GetGroupsRequest
import aws.sdk.kotlin.services.xray.model.GetGroupsResponse
import aws.sdk.kotlin.services.xray.model.GetInsightEventsRequest
import aws.sdk.kotlin.services.xray.model.GetInsightEventsResponse
import aws.sdk.kotlin.services.xray.model.GetInsightImpactGraphRequest
import aws.sdk.kotlin.services.xray.model.GetInsightImpactGraphResponse
import aws.sdk.kotlin.services.xray.model.GetInsightRequest
import aws.sdk.kotlin.services.xray.model.GetInsightResponse
import aws.sdk.kotlin.services.xray.model.GetInsightSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetInsightSummariesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingRulesRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingRulesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingStatisticSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingStatisticSummariesResponse
import aws.sdk.kotlin.services.xray.model.GetSamplingTargetsRequest
import aws.sdk.kotlin.services.xray.model.GetSamplingTargetsResponse
import aws.sdk.kotlin.services.xray.model.GetServiceGraphRequest
import aws.sdk.kotlin.services.xray.model.GetServiceGraphResponse
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsRequest
import aws.sdk.kotlin.services.xray.model.GetTimeSeriesServiceStatisticsResponse
import aws.sdk.kotlin.services.xray.model.GetTraceGraphRequest
import aws.sdk.kotlin.services.xray.model.GetTraceGraphResponse
import aws.sdk.kotlin.services.xray.model.GetTraceSummariesRequest
import aws.sdk.kotlin.services.xray.model.GetTraceSummariesResponse
import aws.sdk.kotlin.services.xray.model.ListResourcePoliciesRequest
import aws.sdk.kotlin.services.xray.model.ListResourcePoliciesResponse
import aws.sdk.kotlin.services.xray.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.xray.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.xray.model.PutEncryptionConfigRequest
import aws.sdk.kotlin.services.xray.model.PutEncryptionConfigResponse
import aws.sdk.kotlin.services.xray.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.xray.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.xray.model.PutTelemetryRecordsRequest
import aws.sdk.kotlin.services.xray.model.PutTelemetryRecordsResponse
import aws.sdk.kotlin.services.xray.model.PutTraceSegmentsRequest
import aws.sdk.kotlin.services.xray.model.PutTraceSegmentsResponse
import aws.sdk.kotlin.services.xray.model.TagResourceRequest
import aws.sdk.kotlin.services.xray.model.TagResourceResponse
import aws.sdk.kotlin.services.xray.model.UntagResourceRequest
import aws.sdk.kotlin.services.xray.model.UntagResourceResponse
import aws.sdk.kotlin.services.xray.model.UpdateGroupRequest
import aws.sdk.kotlin.services.xray.model.UpdateGroupResponse
import aws.sdk.kotlin.services.xray.model.UpdateSamplingRuleRequest
import aws.sdk.kotlin.services.xray.model.UpdateSamplingRuleResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "XRay"
public const val SdkVersion: String = "1.2.30"
public const val ServiceApiVersion: String = "2016-04-12"

/**
 * Amazon Web Services X-Ray provides APIs for managing debug traces and retrieving service maps and other data created by processing those traces.
 */
public interface XRayClient : SdkClient {
    /**
     * XRayClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, XRayClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "XRay",
                "XRAY",
                "xray",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, XRayClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): XRayClient = DefaultXRayClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: XRayEndpointProvider = builder.endpointProvider ?: DefaultXRayEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: XRayAuthSchemeProvider = builder.authSchemeProvider ?: DefaultXRayAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "XRay"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: XRayEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: XRayAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use `GetTraceSummaries` to get a list of trace IDs.
     */
    public suspend fun batchGetTraces(input: BatchGetTracesRequest): BatchGetTracesResponse

    /**
     * Creates a group resource with a name and a filter expression.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with [GetSamplingRules](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html), and evaluate each rule in ascending order of *priority* for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html) to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
     */
    public suspend fun createSamplingRule(input: CreateSamplingRuleRequest): CreateSamplingRuleResponse

    /**
     * Deletes a group resource.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest = DeleteGroupRequest { }): DeleteGroupResponse

    /**
     * Deletes a resource policy from the target Amazon Web Services account.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a sampling rule.
     */
    public suspend fun deleteSamplingRule(input: DeleteSamplingRuleRequest = DeleteSamplingRuleRequest { }): DeleteSamplingRuleResponse

    /**
     * Retrieves the current encryption configuration for X-Ray data.
     */
    public suspend fun getEncryptionConfig(input: GetEncryptionConfigRequest = GetEncryptionConfigRequest { }): GetEncryptionConfigResponse

    /**
     * Retrieves group resource details.
     */
    public suspend fun getGroup(input: GetGroupRequest = GetGroupRequest { }): GetGroupResponse

    /**
     * Retrieves all active group details.
     */
    public suspend fun getGroups(input: GetGroupsRequest = GetGroupsRequest { }): GetGroupsResponse

    /**
     * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.
     */
    public suspend fun getInsight(input: GetInsightRequest): GetInsightResponse

    /**
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     */
    public suspend fun getInsightEvents(input: GetInsightEventsRequest): GetInsightEventsResponse

    /**
     * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.
     */
    public suspend fun getInsightImpactGraph(input: GetInsightImpactGraphRequest): GetInsightImpactGraphResponse

    /**
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     */
    public suspend fun getInsightSummaries(input: GetInsightSummariesRequest): GetInsightSummariesResponse

    /**
     * Retrieves all sampling rules.
     */
    public suspend fun getSamplingRules(input: GetSamplingRulesRequest = GetSamplingRulesRequest { }): GetSamplingRulesResponse

    /**
     * Retrieves information about recent sampling results for all sampling rules.
     */
    public suspend fun getSamplingStatisticSummaries(input: GetSamplingStatisticSummariesRequest = GetSamplingStatisticSummariesRequest { }): GetSamplingStatisticSummariesResponse

    /**
     * Requests a sampling quota for rules that the service is using to sample requests.
     */
    public suspend fun getSamplingTargets(input: GetSamplingTargetsRequest): GetSamplingTargetsResponse

    /**
     * Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the [Amazon Web Services X-Ray SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.
     */
    public suspend fun getServiceGraph(input: GetServiceGraphRequest): GetServiceGraphResponse

    /**
     * Get an aggregation of service statistics defined by a specific time range.
     */
    public suspend fun getTimeSeriesServiceStatistics(input: GetTimeSeriesServiceStatisticsRequest): GetTimeSeriesServiceStatisticsResponse

    /**
     * Retrieves a service graph for one or more specific trace IDs.
     */
    public suspend fun getTraceGraph(input: GetTraceGraphRequest): GetTraceGraphResponse

    /**
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to `BatchGetTraces`.
     *
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through `api.example.com`:
     *
     * `service("api.example.com")`
     *
     * This filter expression finds traces that have an annotation named `account` with the value `12345`:
     *
     * `annotation.account = "12345"`
     *
     * For a full list of indexed fields and keywords that you can use in filter expressions, see [Using Filter Expressions](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html) in the *Amazon Web Services X-Ray Developer Guide*.
     */
    public suspend fun getTraceSummaries(input: GetTraceSummariesRequest): GetTraceSummariesResponse

    /**
     * Returns the list of resource policies in the target Amazon Web Services account.
     */
    public suspend fun listResourcePolicies(input: ListResourcePoliciesRequest = ListResourcePoliciesRequest { }): ListResourcePoliciesResponse

    /**
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Updates the encryption configuration for X-Ray data.
     */
    public suspend fun putEncryptionConfig(input: PutEncryptionConfigRequest): PutEncryptionConfigResponse

    /**
     * Sets the resource policy to grant one or more Amazon Web Services services and accounts permissions to access X-Ray. Each resource policy will be associated with a specific Amazon Web Services account. Each Amazon Web Services account can have a maximum of 5 resource policies, and each policy name must be unique within that account. The maximum size of each resource policy is 5KB.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
     */
    public suspend fun putTelemetryRecords(input: PutTelemetryRecordsRequest): PutTelemetryRecordsResponse

    /**
     * Uploads segment documents to Amazon Web Services X-Ray. The [X-Ray SDK](https://docs.aws.amazon.com/xray/index.html) generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.
     *
     * Segments must include the following fields. For the full segment document schema, see [Amazon Web Services X-Ray Segment Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html) in the *Amazon Web Services X-Ray Developer Guide*.
     *
     * **Required segment document fields**
     * + `name` - The name of the service that handled the request.
     * + `id` - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal digits.
     * + `trace_id` - A unique identifier that connects all segments and subsegments originating from a single client request.
     * + `start_time` - Time the segment or subsegment was created, in floating point seconds in epoch time, accurate to milliseconds. For example, `1480615200.010` or `1.480615200010E9`.
     * + `end_time` - Time the segment or subsegment was closed. For example, `1480615200.090` or `1.480615200090E9`. Specify either an `end_time` or `in_progress`.
     * + `in_progress` - Set to `true` instead of specifying an `end_time` to record that a segment has been started, but is not complete. Send an in-progress segment when your application receives a request that will take a long time to serve, to trace that the request was received. When the response is sent, send the complete segment to overwrite the in-progress segment.
     *
     * A `trace_id` consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979. This includes:
     *
     * **Trace ID Format**
     * + The version number, for instance, `1`.
     * + The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is `1480615200` seconds, or `58406520` in hexadecimal.
     * + A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
     */
    public suspend fun putTraceSegments(input: PutTraceSegmentsRequest): PutTraceSegmentsResponse

    /**
     * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an `aws:` prefix).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a group resource.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest = UpdateGroupRequest { }): UpdateGroupResponse

    /**
     * Modifies a sampling rule's configuration.
     */
    public suspend fun updateSamplingRule(input: UpdateSamplingRuleRequest): UpdateSamplingRuleResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun XRayClient.withConfig(block: XRayClient.Config.Builder.() -> Unit): XRayClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultXRayClient(newConfig)
}

/**
 * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use `GetTraceSummaries` to get a list of trace IDs.
 */
public suspend inline fun XRayClient.batchGetTraces(crossinline block: BatchGetTracesRequest.Builder.() -> Unit): BatchGetTracesResponse = batchGetTraces(BatchGetTracesRequest.Builder().apply(block).build())

/**
 * Creates a group resource with a name and a filter expression.
 */
public suspend inline fun XRayClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with [GetSamplingRules](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html), and evaluate each rule in ascending order of *priority* for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with [GetSamplingTargets](https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html) to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.
 */
public suspend inline fun XRayClient.createSamplingRule(crossinline block: CreateSamplingRuleRequest.Builder.() -> Unit): CreateSamplingRuleResponse = createSamplingRule(CreateSamplingRuleRequest.Builder().apply(block).build())

/**
 * Deletes a group resource.
 */
public suspend inline fun XRayClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes a resource policy from the target Amazon Web Services account.
 */
public suspend inline fun XRayClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a sampling rule.
 */
public suspend inline fun XRayClient.deleteSamplingRule(crossinline block: DeleteSamplingRuleRequest.Builder.() -> Unit): DeleteSamplingRuleResponse = deleteSamplingRule(DeleteSamplingRuleRequest.Builder().apply(block).build())

/**
 * Retrieves the current encryption configuration for X-Ray data.
 */
public suspend inline fun XRayClient.getEncryptionConfig(crossinline block: GetEncryptionConfigRequest.Builder.() -> Unit): GetEncryptionConfigResponse = getEncryptionConfig(GetEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Retrieves group resource details.
 */
public suspend inline fun XRayClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Retrieves all active group details.
 */
public suspend inline fun XRayClient.getGroups(crossinline block: GetGroupsRequest.Builder.() -> Unit): GetGroupsResponse = getGroups(GetGroupsRequest.Builder().apply(block).build())

/**
 * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.
 */
public suspend inline fun XRayClient.getInsight(crossinline block: GetInsightRequest.Builder.() -> Unit): GetInsightResponse = getInsight(GetInsightRequest.Builder().apply(block).build())

/**
 * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
 */
public suspend inline fun XRayClient.getInsightEvents(crossinline block: GetInsightEventsRequest.Builder.() -> Unit): GetInsightEventsResponse = getInsightEvents(GetInsightEventsRequest.Builder().apply(block).build())

/**
 * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.
 */
public suspend inline fun XRayClient.getInsightImpactGraph(crossinline block: GetInsightImpactGraphRequest.Builder.() -> Unit): GetInsightImpactGraphResponse = getInsightImpactGraph(GetInsightImpactGraphRequest.Builder().apply(block).build())

/**
 * Retrieves the summaries of all insights in the specified group matching the provided filter values.
 */
public suspend inline fun XRayClient.getInsightSummaries(crossinline block: GetInsightSummariesRequest.Builder.() -> Unit): GetInsightSummariesResponse = getInsightSummaries(GetInsightSummariesRequest.Builder().apply(block).build())

/**
 * Retrieves all sampling rules.
 */
public suspend inline fun XRayClient.getSamplingRules(crossinline block: GetSamplingRulesRequest.Builder.() -> Unit): GetSamplingRulesResponse = getSamplingRules(GetSamplingRulesRequest.Builder().apply(block).build())

/**
 * Retrieves information about recent sampling results for all sampling rules.
 */
public suspend inline fun XRayClient.getSamplingStatisticSummaries(crossinline block: GetSamplingStatisticSummariesRequest.Builder.() -> Unit): GetSamplingStatisticSummariesResponse = getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest.Builder().apply(block).build())

/**
 * Requests a sampling quota for rules that the service is using to sample requests.
 */
public suspend inline fun XRayClient.getSamplingTargets(crossinline block: GetSamplingTargetsRequest.Builder.() -> Unit): GetSamplingTargetsResponse = getSamplingTargets(GetSamplingTargetsRequest.Builder().apply(block).build())

/**
 * Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the [Amazon Web Services X-Ray SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.
 */
public suspend inline fun XRayClient.getServiceGraph(crossinline block: GetServiceGraphRequest.Builder.() -> Unit): GetServiceGraphResponse = getServiceGraph(GetServiceGraphRequest.Builder().apply(block).build())

/**
 * Get an aggregation of service statistics defined by a specific time range.
 */
public suspend inline fun XRayClient.getTimeSeriesServiceStatistics(crossinline block: GetTimeSeriesServiceStatisticsRequest.Builder.() -> Unit): GetTimeSeriesServiceStatisticsResponse = getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsRequest.Builder().apply(block).build())

/**
 * Retrieves a service graph for one or more specific trace IDs.
 */
public suspend inline fun XRayClient.getTraceGraph(crossinline block: GetTraceGraphRequest.Builder.() -> Unit): GetTraceGraphResponse = getTraceGraph(GetTraceGraphRequest.Builder().apply(block).build())

/**
 * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to `BatchGetTraces`.
 *
 * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through `api.example.com`:
 *
 * `service("api.example.com")`
 *
 * This filter expression finds traces that have an annotation named `account` with the value `12345`:
 *
 * `annotation.account = "12345"`
 *
 * For a full list of indexed fields and keywords that you can use in filter expressions, see [Using Filter Expressions](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html) in the *Amazon Web Services X-Ray Developer Guide*.
 */
public suspend inline fun XRayClient.getTraceSummaries(crossinline block: GetTraceSummariesRequest.Builder.() -> Unit): GetTraceSummariesResponse = getTraceSummaries(GetTraceSummariesRequest.Builder().apply(block).build())

/**
 * Returns the list of resource policies in the target Amazon Web Services account.
 */
public suspend inline fun XRayClient.listResourcePolicies(crossinline block: ListResourcePoliciesRequest.Builder.() -> Unit): ListResourcePoliciesResponse = listResourcePolicies(ListResourcePoliciesRequest.Builder().apply(block).build())

/**
 * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
 */
public suspend inline fun XRayClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Updates the encryption configuration for X-Ray data.
 */
public suspend inline fun XRayClient.putEncryptionConfig(crossinline block: PutEncryptionConfigRequest.Builder.() -> Unit): PutEncryptionConfigResponse = putEncryptionConfig(PutEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Sets the resource policy to grant one or more Amazon Web Services services and accounts permissions to access X-Ray. Each resource policy will be associated with a specific Amazon Web Services account. Each Amazon Web Services account can have a maximum of 5 resource policies, and each policy name must be unique within that account. The maximum size of each resource policy is 5KB.
 */
public suspend inline fun XRayClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
 */
public suspend inline fun XRayClient.putTelemetryRecords(crossinline block: PutTelemetryRecordsRequest.Builder.() -> Unit): PutTelemetryRecordsResponse = putTelemetryRecords(PutTelemetryRecordsRequest.Builder().apply(block).build())

/**
 * Uploads segment documents to Amazon Web Services X-Ray. The [X-Ray SDK](https://docs.aws.amazon.com/xray/index.html) generates segment documents and sends them to the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress segment, or an array of subsegments.
 *
 * Segments must include the following fields. For the full segment document schema, see [Amazon Web Services X-Ray Segment Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html) in the *Amazon Web Services X-Ray Developer Guide*.
 *
 * **Required segment document fields**
 * + `name` - The name of the service that handled the request.
 * + `id` - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal digits.
 * + `trace_id` - A unique identifier that connects all segments and subsegments originating from a single client request.
 * + `start_time` - Time the segment or subsegment was created, in floating point seconds in epoch time, accurate to milliseconds. For example, `1480615200.010` or `1.480615200010E9`.
 * + `end_time` - Time the segment or subsegment was closed. For example, `1480615200.090` or `1.480615200090E9`. Specify either an `end_time` or `in_progress`.
 * + `in_progress` - Set to `true` instead of specifying an `end_time` to record that a segment has been started, but is not complete. Send an in-progress segment when your application receives a request that will take a long time to serve, to trace that the request was received. When the response is sent, send the complete segment to overwrite the in-progress segment.
 *
 * A `trace_id` consists of three numbers separated by hyphens. For example, 1-58406520-a006649127e371903a2de979. This includes:
 *
 * **Trace ID Format**
 * + The version number, for instance, `1`.
 * + The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in epoch time is `1480615200` seconds, or `58406520` in hexadecimal.
 * + A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
 */
public suspend inline fun XRayClient.putTraceSegments(crossinline block: PutTraceSegmentsRequest.Builder.() -> Unit): PutTraceSegmentsResponse = putTraceSegments(PutTraceSegmentsRequest.Builder().apply(block).build())

/**
 * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
 */
public suspend inline fun XRayClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags (those with an `aws:` prefix).
 */
public suspend inline fun XRayClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a group resource.
 */
public suspend inline fun XRayClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Modifies a sampling rule's configuration.
 */
public suspend inline fun XRayClient.updateSamplingRule(crossinline block: UpdateSamplingRuleRequest.Builder.() -> Unit): UpdateSamplingRuleResponse = updateSamplingRule(UpdateSamplingRuleRequest.Builder().apply(block).build())
