// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.transform

import aws.sdk.kotlin.services.workspacesweb.model.AssociateIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.WorkSpacesWebException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssociateIpAccessSettingsOperationDeserializer: HttpDeserialize<AssociateIpAccessSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateIpAccessSettingsResponse {
        if (!response.status.isSuccess()) {
            throwAssociateIpAccessSettingsError(context, response)
        }
        val builder = AssociateIpAccessSettingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssociateIpAccessSettingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAssociateIpAccessSettingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesWebException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesWebException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssociateIpAccessSettingsOperationBody(builder: AssociateIpAccessSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IPACCESSSETTINGSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ipAccessSettingsArn"))
    val PORTALARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portalArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IPACCESSSETTINGSARN_DESCRIPTOR)
        field(PORTALARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IPACCESSSETTINGSARN_DESCRIPTOR.index -> builder.ipAccessSettingsArn = deserializeString()
                PORTALARN_DESCRIPTOR.index -> builder.portalArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
