// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



public class CreatePortalRequest private constructor(builder: Builder) {
    /**
     * The additional encryption context of the portal.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * The type of authentication integration points used when signing into the web portal. Defaults to `Standard`.
     *
     * `Standard` web portals are authenticated directly through your identity provider. You need to call `CreateIdentityProvider` to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.
     *
     * `IAM_Identity_Center` web portals are authenticated through AWS IAM Identity Center (successor to AWS Single Sign-On). They provide additional features, such as IdP-initiated authentication. Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.
     */
    public val authenticationType: aws.sdk.kotlin.services.workspacesweb.model.AuthenticationType? = builder.authenticationType
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.
     *
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The customer managed key of the web portal.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * The name of the web portal. This is not visible to users who log into the web portal.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The tags to add to the web portal. A tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.CreatePortalRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePortalRequest(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("authenticationType=$authenticationType,")
        append("clientToken=$clientToken,")
        append("customerManagedKey=$customerManagedKey,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePortalRequest

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (authenticationType != other.authenticationType) return false
        if (clientToken != other.clientToken) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (displayName != other.displayName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.CreatePortalRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The additional encryption context of the portal.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * The type of authentication integration points used when signing into the web portal. Defaults to `Standard`.
         *
         * `Standard` web portals are authenticated directly through your identity provider. You need to call `CreateIdentityProvider` to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.
         *
         * `IAM_Identity_Center` web portals are authenticated through AWS IAM Identity Center (successor to AWS Single Sign-On). They provide additional features, such as IdP-initiated authentication. Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.
         */
        public var authenticationType: aws.sdk.kotlin.services.workspacesweb.model.AuthenticationType? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.
         *
         * If you do not specify a client token, one is automatically generated by the AWS SDK.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The customer managed key of the web portal.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * The name of the web portal. This is not visible to users who log into the web portal.
         */
        public var displayName: kotlin.String? = null
        /**
         * The tags to add to the web portal. A tag is a key-value pair.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.CreatePortalRequest) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.authenticationType = x.authenticationType
            this.clientToken = x.clientToken
            this.customerManagedKey = x.customerManagedKey
            this.displayName = x.displayName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.CreatePortalRequest = CreatePortalRequest(this)
    }
}
