// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.workspacesweb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.workspacesweb.model.*
import aws.sdk.kotlin.services.workspacesweb.model.AssociateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreatePortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreatePortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeletePortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeletePortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreCertificateRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreCertificateResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.TagResourceRequest
import aws.sdk.kotlin.services.workspacesweb.model.TagResourceResponse
import aws.sdk.kotlin.services.workspacesweb.model.UntagResourceRequest
import aws.sdk.kotlin.services.workspacesweb.model.UntagResourceResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdatePortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdatePortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateUserSettingsResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * WorkSpaces Web is a low cost, fully managed WorkSpace built specifically to facilitate secure, web-based workloads. WorkSpaces Web makes it easy for customers to safely provide their employees with access to internal websites and SaaS web applications without the administrative burden of appliances or specialized client software. WorkSpaces Web provides simple policy tools tailored for user interactions, while offloading common tasks like capacity management, scaling, and maintaining browser images.
 */
public interface WorkSpacesWebClient : SdkClient {

    override val serviceName: String
        get() = "WorkSpaces Web"
    /**
     * WorkSpacesWebClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): WorkSpacesWebClient {
            val config = Config.Builder().apply(block).build()
            return DefaultWorkSpacesWebClient(config)
        }

        public operator fun invoke(config: Config): WorkSpacesWebClient = DefaultWorkSpacesWebClient(config)

        /**
         * Construct a [WorkSpacesWebClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): WorkSpacesWebClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultWorkSpacesWebClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a browser settings resource with a web portal.
     */
    public suspend fun associateBrowserSettings(input: AssociateBrowserSettingsRequest): AssociateBrowserSettingsResponse

    /**
     * Associates a network settings resource with a web portal.
     */
    public suspend fun associateNetworkSettings(input: AssociateNetworkSettingsRequest): AssociateNetworkSettingsResponse

    /**
     * Associates a trust store with a web portal.
     */
    public suspend fun associateTrustStore(input: AssociateTrustStoreRequest): AssociateTrustStoreResponse

    /**
     * Associates a user settings resource with a web portal.
     */
    public suspend fun associateUserSettings(input: AssociateUserSettingsRequest): AssociateUserSettingsResponse

    /**
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     */
    public suspend fun createBrowserSettings(input: CreateBrowserSettingsRequest): CreateBrowserSettingsResponse

    /**
     * Creates an identity provider resource that is then associated with a web portal.
     */
    public suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse

    /**
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.
     */
    public suspend fun createNetworkSettings(input: CreateNetworkSettingsRequest): CreateNetworkSettingsResponse

    /**
     * Creates a web portal.
     */
    public suspend fun createPortal(input: CreatePortalRequest = CreatePortalRequest {}): CreatePortalResponse

    /**
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     */
    public suspend fun createTrustStore(input: CreateTrustStoreRequest): CreateTrustStoreResponse

    /**
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.
     */
    public suspend fun createUserSettings(input: CreateUserSettingsRequest): CreateUserSettingsResponse

    /**
     * Deletes browser settings.
     */
    public suspend fun deleteBrowserSettings(input: DeleteBrowserSettingsRequest): DeleteBrowserSettingsResponse

    /**
     * Deletes the identity provider.
     */
    public suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse

    /**
     * Deletes network settings.
     */
    public suspend fun deleteNetworkSettings(input: DeleteNetworkSettingsRequest): DeleteNetworkSettingsResponse

    /**
     * Deletes a web portal.
     */
    public suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse

    /**
     * Deletes the trust store.
     */
    public suspend fun deleteTrustStore(input: DeleteTrustStoreRequest): DeleteTrustStoreResponse

    /**
     * Deletes user settings.
     */
    public suspend fun deleteUserSettings(input: DeleteUserSettingsRequest): DeleteUserSettingsResponse

    /**
     * Disassociates browser settings from a web portal.
     */
    public suspend fun disassociateBrowserSettings(input: DisassociateBrowserSettingsRequest): DisassociateBrowserSettingsResponse

    /**
     * Disassociates network settings from a web portal.
     */
    public suspend fun disassociateNetworkSettings(input: DisassociateNetworkSettingsRequest): DisassociateNetworkSettingsResponse

    /**
     * Disassociates a trust store from a web portal.
     */
    public suspend fun disassociateTrustStore(input: DisassociateTrustStoreRequest): DisassociateTrustStoreResponse

    /**
     * Disassociates user settings from a web portal.
     */
    public suspend fun disassociateUserSettings(input: DisassociateUserSettingsRequest): DisassociateUserSettingsResponse

    /**
     * Gets browser settings.
     */
    public suspend fun getBrowserSettings(input: GetBrowserSettingsRequest): GetBrowserSettingsResponse

    /**
     * Gets the identity provider.
     */
    public suspend fun getIdentityProvider(input: GetIdentityProviderRequest): GetIdentityProviderResponse

    /**
     * Gets the network settings.
     */
    public suspend fun getNetworkSettings(input: GetNetworkSettingsRequest): GetNetworkSettingsResponse

    /**
     * Gets the web portal.
     */
    public suspend fun getPortal(input: GetPortalRequest): GetPortalResponse

    /**
     * Gets the service provider metadata.
     */
    public suspend fun getPortalServiceProviderMetadata(input: GetPortalServiceProviderMetadataRequest): GetPortalServiceProviderMetadataResponse

    /**
     * Gets the trust store.
     */
    public suspend fun getTrustStore(input: GetTrustStoreRequest): GetTrustStoreResponse

    /**
     * Gets the trust store certificate.
     */
    public suspend fun getTrustStoreCertificate(input: GetTrustStoreCertificateRequest): GetTrustStoreCertificateResponse

    /**
     * Gets user settings.
     */
    public suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse

    /**
     * Retrieves a list of browser settings.
     */
    public suspend fun listBrowserSettings(input: ListBrowserSettingsRequest = ListBrowserSettingsRequest {}): ListBrowserSettingsResponse

    /**
     * Retrieves a list of identity providers for a specific web portal.
     */
    public suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse

    /**
     * Retrieves a list of network settings.
     */
    public suspend fun listNetworkSettings(input: ListNetworkSettingsRequest = ListNetworkSettingsRequest {}): ListNetworkSettingsResponse

    /**
     * Retrieves a list or web portals.
     */
    public suspend fun listPortals(input: ListPortalsRequest = ListPortalsRequest {}): ListPortalsResponse

    /**
     * Retrieves a list of tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of trust store certificates.
     */
    public suspend fun listTrustStoreCertificates(input: ListTrustStoreCertificatesRequest): ListTrustStoreCertificatesResponse

    /**
     * Retrieves a list of trust stores.
     */
    public suspend fun listTrustStores(input: ListTrustStoresRequest = ListTrustStoresRequest {}): ListTrustStoresResponse

    /**
     * Retrieves a list of user settings.
     */
    public suspend fun listUserSettings(input: ListUserSettingsRequest = ListUserSettingsRequest {}): ListUserSettingsResponse

    /**
     * Adds or overwrites one or more tags for the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates browser settings.
     */
    public suspend fun updateBrowserSettings(input: UpdateBrowserSettingsRequest): UpdateBrowserSettingsResponse

    /**
     * Updates the identity provider.
     */
    public suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse

    /**
     * Updates network settings.
     */
    public suspend fun updateNetworkSettings(input: UpdateNetworkSettingsRequest): UpdateNetworkSettingsResponse

    /**
     * Updates a web portal.
     */
    public suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse

    /**
     * Updates the trust store.
     */
    public suspend fun updateTrustStore(input: UpdateTrustStoreRequest): UpdateTrustStoreResponse

    /**
     * Updates the user settings.
     */
    public suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse
}

/**
 * Associates a browser settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateBrowserSettings(crossinline block: AssociateBrowserSettingsRequest.Builder.() -> Unit): AssociateBrowserSettingsResponse = associateBrowserSettings(AssociateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Associates a network settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateNetworkSettings(crossinline block: AssociateNetworkSettingsRequest.Builder.() -> Unit): AssociateNetworkSettingsResponse = associateNetworkSettings(AssociateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Associates a trust store with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateTrustStore(crossinline block: AssociateTrustStoreRequest.Builder.() -> Unit): AssociateTrustStoreResponse = associateTrustStore(AssociateTrustStoreRequest.Builder().apply(block).build())

/**
 * Associates a user settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateUserSettings(crossinline block: AssociateUserSettingsRequest.Builder.() -> Unit): AssociateUserSettingsResponse = associateUserSettings(AssociateUserSettingsRequest.Builder().apply(block).build())

/**
 * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal.
 */
public suspend inline fun WorkSpacesWebClient.createBrowserSettings(crossinline block: CreateBrowserSettingsRequest.Builder.() -> Unit): CreateBrowserSettingsResponse = createBrowserSettings(CreateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Creates an identity provider resource that is then associated with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.createIdentityProvider(crossinline block: CreateIdentityProviderRequest.Builder.() -> Unit): CreateIdentityProviderResponse = createIdentityProvider(CreateIdentityProviderRequest.Builder().apply(block).build())

/**
 * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.
 */
public suspend inline fun WorkSpacesWebClient.createNetworkSettings(crossinline block: CreateNetworkSettingsRequest.Builder.() -> Unit): CreateNetworkSettingsResponse = createNetworkSettings(CreateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Creates a web portal.
 */
public suspend inline fun WorkSpacesWebClient.createPortal(crossinline block: CreatePortalRequest.Builder.() -> Unit): CreatePortalResponse = createPortal(CreatePortalRequest.Builder().apply(block).build())

/**
 * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.
 */
public suspend inline fun WorkSpacesWebClient.createTrustStore(crossinline block: CreateTrustStoreRequest.Builder.() -> Unit): CreateTrustStoreResponse = createTrustStore(CreateTrustStoreRequest.Builder().apply(block).build())

/**
 * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.
 */
public suspend inline fun WorkSpacesWebClient.createUserSettings(crossinline block: CreateUserSettingsRequest.Builder.() -> Unit): CreateUserSettingsResponse = createUserSettings(CreateUserSettingsRequest.Builder().apply(block).build())

/**
 * Deletes browser settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteBrowserSettings(crossinline block: DeleteBrowserSettingsRequest.Builder.() -> Unit): DeleteBrowserSettingsResponse = deleteBrowserSettings(DeleteBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Deletes the identity provider.
 */
public suspend inline fun WorkSpacesWebClient.deleteIdentityProvider(crossinline block: DeleteIdentityProviderRequest.Builder.() -> Unit): DeleteIdentityProviderResponse = deleteIdentityProvider(DeleteIdentityProviderRequest.Builder().apply(block).build())

/**
 * Deletes network settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteNetworkSettings(crossinline block: DeleteNetworkSettingsRequest.Builder.() -> Unit): DeleteNetworkSettingsResponse = deleteNetworkSettings(DeleteNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Deletes a web portal.
 */
public suspend inline fun WorkSpacesWebClient.deletePortal(crossinline block: DeletePortalRequest.Builder.() -> Unit): DeletePortalResponse = deletePortal(DeletePortalRequest.Builder().apply(block).build())

/**
 * Deletes the trust store.
 */
public suspend inline fun WorkSpacesWebClient.deleteTrustStore(crossinline block: DeleteTrustStoreRequest.Builder.() -> Unit): DeleteTrustStoreResponse = deleteTrustStore(DeleteTrustStoreRequest.Builder().apply(block).build())

/**
 * Deletes user settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteUserSettings(crossinline block: DeleteUserSettingsRequest.Builder.() -> Unit): DeleteUserSettingsResponse = deleteUserSettings(DeleteUserSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates browser settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateBrowserSettings(crossinline block: DisassociateBrowserSettingsRequest.Builder.() -> Unit): DisassociateBrowserSettingsResponse = disassociateBrowserSettings(DisassociateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates network settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateNetworkSettings(crossinline block: DisassociateNetworkSettingsRequest.Builder.() -> Unit): DisassociateNetworkSettingsResponse = disassociateNetworkSettings(DisassociateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates a trust store from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateTrustStore(crossinline block: DisassociateTrustStoreRequest.Builder.() -> Unit): DisassociateTrustStoreResponse = disassociateTrustStore(DisassociateTrustStoreRequest.Builder().apply(block).build())

/**
 * Disassociates user settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateUserSettings(crossinline block: DisassociateUserSettingsRequest.Builder.() -> Unit): DisassociateUserSettingsResponse = disassociateUserSettings(DisassociateUserSettingsRequest.Builder().apply(block).build())

/**
 * Gets browser settings.
 */
public suspend inline fun WorkSpacesWebClient.getBrowserSettings(crossinline block: GetBrowserSettingsRequest.Builder.() -> Unit): GetBrowserSettingsResponse = getBrowserSettings(GetBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Gets the identity provider.
 */
public suspend inline fun WorkSpacesWebClient.getIdentityProvider(crossinline block: GetIdentityProviderRequest.Builder.() -> Unit): GetIdentityProviderResponse = getIdentityProvider(GetIdentityProviderRequest.Builder().apply(block).build())

/**
 * Gets the network settings.
 */
public suspend inline fun WorkSpacesWebClient.getNetworkSettings(crossinline block: GetNetworkSettingsRequest.Builder.() -> Unit): GetNetworkSettingsResponse = getNetworkSettings(GetNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Gets the web portal.
 */
public suspend inline fun WorkSpacesWebClient.getPortal(crossinline block: GetPortalRequest.Builder.() -> Unit): GetPortalResponse = getPortal(GetPortalRequest.Builder().apply(block).build())

/**
 * Gets the service provider metadata.
 */
public suspend inline fun WorkSpacesWebClient.getPortalServiceProviderMetadata(crossinline block: GetPortalServiceProviderMetadataRequest.Builder.() -> Unit): GetPortalServiceProviderMetadataResponse = getPortalServiceProviderMetadata(GetPortalServiceProviderMetadataRequest.Builder().apply(block).build())

/**
 * Gets the trust store.
 */
public suspend inline fun WorkSpacesWebClient.getTrustStore(crossinline block: GetTrustStoreRequest.Builder.() -> Unit): GetTrustStoreResponse = getTrustStore(GetTrustStoreRequest.Builder().apply(block).build())

/**
 * Gets the trust store certificate.
 */
public suspend inline fun WorkSpacesWebClient.getTrustStoreCertificate(crossinline block: GetTrustStoreCertificateRequest.Builder.() -> Unit): GetTrustStoreCertificateResponse = getTrustStoreCertificate(GetTrustStoreCertificateRequest.Builder().apply(block).build())

/**
 * Gets user settings.
 */
public suspend inline fun WorkSpacesWebClient.getUserSettings(crossinline block: GetUserSettingsRequest.Builder.() -> Unit): GetUserSettingsResponse = getUserSettings(GetUserSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of browser settings.
 */
public suspend inline fun WorkSpacesWebClient.listBrowserSettings(crossinline block: ListBrowserSettingsRequest.Builder.() -> Unit): ListBrowserSettingsResponse = listBrowserSettings(ListBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of identity providers for a specific web portal.
 */
public suspend inline fun WorkSpacesWebClient.listIdentityProviders(crossinline block: ListIdentityProvidersRequest.Builder.() -> Unit): ListIdentityProvidersResponse = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Retrieves a list of network settings.
 */
public suspend inline fun WorkSpacesWebClient.listNetworkSettings(crossinline block: ListNetworkSettingsRequest.Builder.() -> Unit): ListNetworkSettingsResponse = listNetworkSettings(ListNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list or web portals.
 */
public suspend inline fun WorkSpacesWebClient.listPortals(crossinline block: ListPortalsRequest.Builder.() -> Unit): ListPortalsResponse = listPortals(ListPortalsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of tags for a resource.
 */
public suspend inline fun WorkSpacesWebClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of trust store certificates.
 */
public suspend inline fun WorkSpacesWebClient.listTrustStoreCertificates(crossinline block: ListTrustStoreCertificatesRequest.Builder.() -> Unit): ListTrustStoreCertificatesResponse = listTrustStoreCertificates(ListTrustStoreCertificatesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of trust stores.
 */
public suspend inline fun WorkSpacesWebClient.listTrustStores(crossinline block: ListTrustStoresRequest.Builder.() -> Unit): ListTrustStoresResponse = listTrustStores(ListTrustStoresRequest.Builder().apply(block).build())

/**
 * Retrieves a list of user settings.
 */
public suspend inline fun WorkSpacesWebClient.listUserSettings(crossinline block: ListUserSettingsRequest.Builder.() -> Unit): ListUserSettingsResponse = listUserSettings(ListUserSettingsRequest.Builder().apply(block).build())

/**
 * Adds or overwrites one or more tags for the specified resource.
 */
public suspend inline fun WorkSpacesWebClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun WorkSpacesWebClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates browser settings.
 */
public suspend inline fun WorkSpacesWebClient.updateBrowserSettings(crossinline block: UpdateBrowserSettingsRequest.Builder.() -> Unit): UpdateBrowserSettingsResponse = updateBrowserSettings(UpdateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Updates the identity provider.
 */
public suspend inline fun WorkSpacesWebClient.updateIdentityProvider(crossinline block: UpdateIdentityProviderRequest.Builder.() -> Unit): UpdateIdentityProviderResponse = updateIdentityProvider(UpdateIdentityProviderRequest.Builder().apply(block).build())

/**
 * Updates network settings.
 */
public suspend inline fun WorkSpacesWebClient.updateNetworkSettings(crossinline block: UpdateNetworkSettingsRequest.Builder.() -> Unit): UpdateNetworkSettingsResponse = updateNetworkSettings(UpdateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Updates a web portal.
 */
public suspend inline fun WorkSpacesWebClient.updatePortal(crossinline block: UpdatePortalRequest.Builder.() -> Unit): UpdatePortalResponse = updatePortal(UpdatePortalRequest.Builder().apply(block).build())

/**
 * Updates the trust store.
 */
public suspend inline fun WorkSpacesWebClient.updateTrustStore(crossinline block: UpdateTrustStoreRequest.Builder.() -> Unit): UpdateTrustStoreResponse = updateTrustStore(UpdateTrustStoreRequest.Builder().apply(block).build())

/**
 * Updates the user settings.
 */
public suspend inline fun WorkSpacesWebClient.updateUserSettings(crossinline block: UpdateUserSettingsRequest.Builder.() -> Unit): UpdateUserSettingsResponse = updateUserSettings(UpdateUserSettingsRequest.Builder().apply(block).build())
