// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.serde

import aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateIdentityProviderOperationSerializer: HttpSerializer.NonStreaming<UpdateIdentityProviderRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateIdentityProviderRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.identityProviderArn) { "identityProviderArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("identityProviders"))
                input.identityProviderArn.split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
        }

        val payload = serializeUpdateIdentityProviderOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateIdentityProviderOperationBody(context: ExecutionContext, input: UpdateIdentityProviderRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val IDENTITYPROVIDERDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("identityProviderDetails"))
    val IDENTITYPROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityProviderName"))
    val IDENTITYPROVIDERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityProviderType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(IDENTITYPROVIDERDETAILS_DESCRIPTOR)
        field(IDENTITYPROVIDERNAME_DESCRIPTOR)
        field(IDENTITYPROVIDERTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.identityProviderDetails != null) {
            mapField(IDENTITYPROVIDERDETAILS_DESCRIPTOR) {
                input.identityProviderDetails.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.identityProviderName?.let { field(IDENTITYPROVIDERNAME_DESCRIPTOR, it) }
        input.identityProviderType?.let { field(IDENTITYPROVIDERTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
