// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The web portal.
 */
public class Portal private constructor(builder: Builder) {
    /**
     * The additional encryption context of the portal.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * The type of authentication integration points used when signing into the web portal. Defaults to `Standard`.
     *
     * `Standard` web portals are authenticated directly through your identity provider. You need to call `CreateIdentityProvider` to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.
     *
     * `IAM Identity Center` web portals are authenticated through IAM Identity Center. Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.
     */
    public val authenticationType: aws.sdk.kotlin.services.workspacesweb.model.AuthenticationType? = builder.authenticationType
    /**
     * The ARN of the browser settings that is associated with this web portal.
     */
    public val browserSettingsArn: kotlin.String? = builder.browserSettingsArn
    /**
     * The browser that users see when using a streaming session.
     */
    public val browserType: aws.sdk.kotlin.services.workspacesweb.model.BrowserType? = builder.browserType
    /**
     * The creation date of the web portal.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The customer managed key used to encrypt sensitive information in the portal.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * The ARN of the data protection settings.
     */
    public val dataProtectionSettingsArn: kotlin.String? = builder.dataProtectionSettingsArn
    /**
     * The name of the web portal.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The type and resources of the underlying instance.
     */
    public val instanceType: aws.sdk.kotlin.services.workspacesweb.model.InstanceType? = builder.instanceType
    /**
     * The ARN of the IP access settings.
     */
    public val ipAccessSettingsArn: kotlin.String? = builder.ipAccessSettingsArn
    /**
     * The maximum number of concurrent sessions for the portal.
     */
    public val maxConcurrentSessions: kotlin.Int? = builder.maxConcurrentSessions
    /**
     * The ARN of the network settings that is associated with the web portal.
     */
    public val networkSettingsArn: kotlin.String? = builder.networkSettingsArn
    /**
     * The ARN of the web portal.
     */
    public val portalArn: kotlin.String = requireNotNull(builder.portalArn) { "A non-null value must be provided for portalArn" }
    /**
     * The endpoint URL of the web portal that users access in order to start streaming sessions.
     */
    public val portalEndpoint: kotlin.String? = builder.portalEndpoint
    /**
     * The status of the web portal.
     */
    public val portalStatus: aws.sdk.kotlin.services.workspacesweb.model.PortalStatus? = builder.portalStatus
    /**
     * The renderer that is used in streaming sessions.
     */
    public val rendererType: aws.sdk.kotlin.services.workspacesweb.model.RendererType? = builder.rendererType
    /**
     * A message that explains why the web portal is in its current status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The ARN of the trust store that is associated with the web portal.
     */
    public val trustStoreArn: kotlin.String? = builder.trustStoreArn
    /**
     * The ARN of the user access logging settings that is associated with the web portal.
     */
    public val userAccessLoggingSettingsArn: kotlin.String? = builder.userAccessLoggingSettingsArn
    /**
     * The ARN of the user settings that is associated with the web portal.
     */
    public val userSettingsArn: kotlin.String? = builder.userSettingsArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.Portal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Portal(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("authenticationType=$authenticationType,")
        append("browserSettingsArn=$browserSettingsArn,")
        append("browserType=$browserType,")
        append("creationDate=$creationDate,")
        append("customerManagedKey=$customerManagedKey,")
        append("dataProtectionSettingsArn=$dataProtectionSettingsArn,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("instanceType=$instanceType,")
        append("ipAccessSettingsArn=$ipAccessSettingsArn,")
        append("maxConcurrentSessions=$maxConcurrentSessions,")
        append("networkSettingsArn=$networkSettingsArn,")
        append("portalArn=$portalArn,")
        append("portalEndpoint=$portalEndpoint,")
        append("portalStatus=$portalStatus,")
        append("rendererType=$rendererType,")
        append("statusReason=$statusReason,")
        append("trustStoreArn=$trustStoreArn,")
        append("userAccessLoggingSettingsArn=$userAccessLoggingSettingsArn,")
        append("userSettingsArn=$userSettingsArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (browserSettingsArn?.hashCode() ?: 0)
        result = 31 * result + (browserType?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (dataProtectionSettingsArn?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (ipAccessSettingsArn?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrentSessions ?: 0)
        result = 31 * result + (networkSettingsArn?.hashCode() ?: 0)
        result = 31 * result + (portalArn.hashCode())
        result = 31 * result + (portalEndpoint?.hashCode() ?: 0)
        result = 31 * result + (portalStatus?.hashCode() ?: 0)
        result = 31 * result + (rendererType?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (trustStoreArn?.hashCode() ?: 0)
        result = 31 * result + (userAccessLoggingSettingsArn?.hashCode() ?: 0)
        result = 31 * result + (userSettingsArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Portal

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (authenticationType != other.authenticationType) return false
        if (browserSettingsArn != other.browserSettingsArn) return false
        if (browserType != other.browserType) return false
        if (creationDate != other.creationDate) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (dataProtectionSettingsArn != other.dataProtectionSettingsArn) return false
        if (displayName != other.displayName) return false
        if (instanceType != other.instanceType) return false
        if (ipAccessSettingsArn != other.ipAccessSettingsArn) return false
        if (maxConcurrentSessions != other.maxConcurrentSessions) return false
        if (networkSettingsArn != other.networkSettingsArn) return false
        if (portalArn != other.portalArn) return false
        if (portalEndpoint != other.portalEndpoint) return false
        if (portalStatus != other.portalStatus) return false
        if (rendererType != other.rendererType) return false
        if (statusReason != other.statusReason) return false
        if (trustStoreArn != other.trustStoreArn) return false
        if (userAccessLoggingSettingsArn != other.userAccessLoggingSettingsArn) return false
        if (userSettingsArn != other.userSettingsArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.Portal = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The additional encryption context of the portal.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * The type of authentication integration points used when signing into the web portal. Defaults to `Standard`.
         *
         * `Standard` web portals are authenticated directly through your identity provider. You need to call `CreateIdentityProvider` to integrate your identity provider with your web portal. User and group access to your web portal is controlled through your identity provider.
         *
         * `IAM Identity Center` web portals are authenticated through IAM Identity Center. Identity sources (including external identity provider integration), plus user and group access to your web portal, can be configured in the IAM Identity Center.
         */
        public var authenticationType: aws.sdk.kotlin.services.workspacesweb.model.AuthenticationType? = null
        /**
         * The ARN of the browser settings that is associated with this web portal.
         */
        public var browserSettingsArn: kotlin.String? = null
        /**
         * The browser that users see when using a streaming session.
         */
        public var browserType: aws.sdk.kotlin.services.workspacesweb.model.BrowserType? = null
        /**
         * The creation date of the web portal.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer managed key used to encrypt sensitive information in the portal.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * The ARN of the data protection settings.
         */
        public var dataProtectionSettingsArn: kotlin.String? = null
        /**
         * The name of the web portal.
         */
        public var displayName: kotlin.String? = null
        /**
         * The type and resources of the underlying instance.
         */
        public var instanceType: aws.sdk.kotlin.services.workspacesweb.model.InstanceType? = null
        /**
         * The ARN of the IP access settings.
         */
        public var ipAccessSettingsArn: kotlin.String? = null
        /**
         * The maximum number of concurrent sessions for the portal.
         */
        public var maxConcurrentSessions: kotlin.Int? = null
        /**
         * The ARN of the network settings that is associated with the web portal.
         */
        public var networkSettingsArn: kotlin.String? = null
        /**
         * The ARN of the web portal.
         */
        public var portalArn: kotlin.String? = null
        /**
         * The endpoint URL of the web portal that users access in order to start streaming sessions.
         */
        public var portalEndpoint: kotlin.String? = null
        /**
         * The status of the web portal.
         */
        public var portalStatus: aws.sdk.kotlin.services.workspacesweb.model.PortalStatus? = null
        /**
         * The renderer that is used in streaming sessions.
         */
        public var rendererType: aws.sdk.kotlin.services.workspacesweb.model.RendererType? = null
        /**
         * A message that explains why the web portal is in its current status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The ARN of the trust store that is associated with the web portal.
         */
        public var trustStoreArn: kotlin.String? = null
        /**
         * The ARN of the user access logging settings that is associated with the web portal.
         */
        public var userAccessLoggingSettingsArn: kotlin.String? = null
        /**
         * The ARN of the user settings that is associated with the web portal.
         */
        public var userSettingsArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.Portal) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.authenticationType = x.authenticationType
            this.browserSettingsArn = x.browserSettingsArn
            this.browserType = x.browserType
            this.creationDate = x.creationDate
            this.customerManagedKey = x.customerManagedKey
            this.dataProtectionSettingsArn = x.dataProtectionSettingsArn
            this.displayName = x.displayName
            this.instanceType = x.instanceType
            this.ipAccessSettingsArn = x.ipAccessSettingsArn
            this.maxConcurrentSessions = x.maxConcurrentSessions
            this.networkSettingsArn = x.networkSettingsArn
            this.portalArn = x.portalArn
            this.portalEndpoint = x.portalEndpoint
            this.portalStatus = x.portalStatus
            this.rendererType = x.rendererType
            this.statusReason = x.statusReason
            this.trustStoreArn = x.trustStoreArn
            this.userAccessLoggingSettingsArn = x.userAccessLoggingSettingsArn
            this.userSettingsArn = x.userSettingsArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.Portal = Portal(this)

        internal fun correctErrors(): Builder {
            if (portalArn == null) portalArn = ""
            return this
        }
    }
}
