// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The set of patterns that determine the data types redacted in session.
 */
public class InlineRedactionPattern private constructor(builder: Builder) {
    /**
     * The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required.
     */
    public val builtInPatternId: kotlin.String? = builder.builtInPatternId
    /**
     * The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
     */
    public val confidenceLevel: kotlin.Int? = builder.confidenceLevel
    /**
     * >The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
     */
    public val customPattern: aws.sdk.kotlin.services.workspacesweb.model.CustomPattern? = builder.customPattern
    /**
     * The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
     */
    public val enforcedUrls: List<String>? = builder.enforcedUrls
    /**
     * The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
     */
    public val exemptUrls: List<String>? = builder.exemptUrls
    /**
     * The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
     */
    public val redactionPlaceHolder: aws.sdk.kotlin.services.workspacesweb.model.RedactionPlaceHolder? = builder.redactionPlaceHolder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionPattern = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InlineRedactionPattern(")
        append("builtInPatternId=*** Sensitive Data Redacted ***,")
        append("confidenceLevel=$confidenceLevel,")
        append("customPattern=$customPattern,")
        append("enforcedUrls=*** Sensitive Data Redacted ***,")
        append("exemptUrls=*** Sensitive Data Redacted ***,")
        append("redactionPlaceHolder=$redactionPlaceHolder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = builtInPatternId?.hashCode() ?: 0
        result = 31 * result + (confidenceLevel ?: 0)
        result = 31 * result + (customPattern?.hashCode() ?: 0)
        result = 31 * result + (enforcedUrls?.hashCode() ?: 0)
        result = 31 * result + (exemptUrls?.hashCode() ?: 0)
        result = 31 * result + (redactionPlaceHolder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InlineRedactionPattern

        if (builtInPatternId != other.builtInPatternId) return false
        if (confidenceLevel != other.confidenceLevel) return false
        if (customPattern != other.customPattern) return false
        if (enforcedUrls != other.enforcedUrls) return false
        if (exemptUrls != other.exemptUrls) return false
        if (redactionPlaceHolder != other.redactionPlaceHolder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionPattern = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required.
         */
        public var builtInPatternId: kotlin.String? = null
        /**
         * The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
         */
        public var confidenceLevel: kotlin.Int? = null
        /**
         * >The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
         */
        public var customPattern: aws.sdk.kotlin.services.workspacesweb.model.CustomPattern? = null
        /**
         * The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
         */
        public var enforcedUrls: List<String>? = null
        /**
         * The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
         */
        public var exemptUrls: List<String>? = null
        /**
         * The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
         */
        public var redactionPlaceHolder: aws.sdk.kotlin.services.workspacesweb.model.RedactionPlaceHolder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionPattern) : this() {
            this.builtInPatternId = x.builtInPatternId
            this.confidenceLevel = x.confidenceLevel
            this.customPattern = x.customPattern
            this.enforcedUrls = x.enforcedUrls
            this.exemptUrls = x.exemptUrls
            this.redactionPlaceHolder = x.redactionPlaceHolder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionPattern = InlineRedactionPattern(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspacesweb.model.CustomPattern] inside the given [block]
         */
        public fun customPattern(block: aws.sdk.kotlin.services.workspacesweb.model.CustomPattern.Builder.() -> kotlin.Unit) {
            this.customPattern = aws.sdk.kotlin.services.workspacesweb.model.CustomPattern.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspacesweb.model.RedactionPlaceHolder] inside the given [block]
         */
        public fun redactionPlaceHolder(block: aws.sdk.kotlin.services.workspacesweb.model.RedactionPlaceHolder.Builder.() -> kotlin.Unit) {
            this.redactionPlaceHolder = aws.sdk.kotlin.services.workspacesweb.model.RedactionPlaceHolder.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
