// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for in-session inline redaction.
 */
public class InlineRedactionConfiguration private constructor(builder: Builder) {
    /**
     * The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
     */
    public val globalConfidenceLevel: kotlin.Int? = builder.globalConfidenceLevel
    /**
     * The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
     */
    public val globalEnforcedUrls: List<String>? = builder.globalEnforcedUrls
    /**
     * The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
     */
    public val globalExemptUrls: List<String>? = builder.globalExemptUrls
    /**
     * The inline redaction patterns to be enabled for the inline redaction configuration.
     */
    public val inlineRedactionPatterns: List<InlineRedactionPattern> = requireNotNull(builder.inlineRedactionPatterns) { "A non-null value must be provided for inlineRedactionPatterns" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InlineRedactionConfiguration(")
        append("globalConfidenceLevel=$globalConfidenceLevel,")
        append("globalEnforcedUrls=*** Sensitive Data Redacted ***,")
        append("globalExemptUrls=*** Sensitive Data Redacted ***,")
        append("inlineRedactionPatterns=$inlineRedactionPatterns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalConfidenceLevel ?: 0
        result = 31 * result + (globalEnforcedUrls?.hashCode() ?: 0)
        result = 31 * result + (globalExemptUrls?.hashCode() ?: 0)
        result = 31 * result + (inlineRedactionPatterns.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InlineRedactionConfiguration

        if (globalConfidenceLevel != other.globalConfidenceLevel) return false
        if (globalEnforcedUrls != other.globalEnforcedUrls) return false
        if (globalExemptUrls != other.globalExemptUrls) return false
        if (inlineRedactionPatterns != other.inlineRedactionPatterns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
         */
        public var globalConfidenceLevel: kotlin.Int? = null
        /**
         * The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
         */
        public var globalEnforcedUrls: List<String>? = null
        /**
         * The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
         */
        public var globalExemptUrls: List<String>? = null
        /**
         * The inline redaction patterns to be enabled for the inline redaction configuration.
         */
        public var inlineRedactionPatterns: List<InlineRedactionPattern>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration) : this() {
            this.globalConfidenceLevel = x.globalConfidenceLevel
            this.globalEnforcedUrls = x.globalEnforcedUrls
            this.globalExemptUrls = x.globalExemptUrls
            this.inlineRedactionPatterns = x.inlineRedactionPatterns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration = InlineRedactionConfiguration(this)

        internal fun correctErrors(): Builder {
            if (inlineRedactionPatterns == null) inlineRedactionPatterns = emptyList()
            return this
        }
    }
}
