// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The data protection settings resource that can be associated with a web portal.
 */
public class DataProtectionSettings private constructor(builder: Builder) {
    /**
     * The additional encryption context of the data protection settings.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * A list of web portal ARNs that this data protection settings resource is associated with.
     */
    public val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The creation date timestamp of the data protection settings.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The customer managed key used to encrypt sensitive information in the data protection settings.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * The ARN of the data protection settings resource.
     */
    public val dataProtectionSettingsArn: kotlin.String = requireNotNull(builder.dataProtectionSettingsArn) { "A non-null value must be provided for dataProtectionSettingsArn" }
    /**
     * The description of the data protection settings.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name of the data protection settings.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The inline redaction configuration for the data protection settings.
     */
    public val inlineRedactionConfiguration: aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration? = builder.inlineRedactionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.DataProtectionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataProtectionSettings(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("associatedPortalArns=$associatedPortalArns,")
        append("creationDate=$creationDate,")
        append("customerManagedKey=$customerManagedKey,")
        append("dataProtectionSettingsArn=$dataProtectionSettingsArn,")
        append("description=*** Sensitive Data Redacted ***,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("inlineRedactionConfiguration=$inlineRedactionConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (associatedPortalArns?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (dataProtectionSettingsArn.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (inlineRedactionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataProtectionSettings

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (associatedPortalArns != other.associatedPortalArns) return false
        if (creationDate != other.creationDate) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (dataProtectionSettingsArn != other.dataProtectionSettingsArn) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (inlineRedactionConfiguration != other.inlineRedactionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.DataProtectionSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The additional encryption context of the data protection settings.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * A list of web portal ARNs that this data protection settings resource is associated with.
         */
        public var associatedPortalArns: List<String>? = null
        /**
         * The creation date timestamp of the data protection settings.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer managed key used to encrypt sensitive information in the data protection settings.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * The ARN of the data protection settings resource.
         */
        public var dataProtectionSettingsArn: kotlin.String? = null
        /**
         * The description of the data protection settings.
         */
        public var description: kotlin.String? = null
        /**
         * The display name of the data protection settings.
         */
        public var displayName: kotlin.String? = null
        /**
         * The inline redaction configuration for the data protection settings.
         */
        public var inlineRedactionConfiguration: aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.DataProtectionSettings) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.associatedPortalArns = x.associatedPortalArns
            this.creationDate = x.creationDate
            this.customerManagedKey = x.customerManagedKey
            this.dataProtectionSettingsArn = x.dataProtectionSettingsArn
            this.description = x.description
            this.displayName = x.displayName
            this.inlineRedactionConfiguration = x.inlineRedactionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.DataProtectionSettings = DataProtectionSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration] inside the given [block]
         */
        public fun inlineRedactionConfiguration(block: aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration.Builder.() -> kotlin.Unit) {
            this.inlineRedactionConfiguration = aws.sdk.kotlin.services.workspacesweb.model.InlineRedactionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataProtectionSettingsArn == null) dataProtectionSettingsArn = ""
            return this
        }
    }
}
