// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The pattern configuration for redacting custom data types in session.
 */
public class CustomPattern private constructor(builder: Builder) {
    /**
     * The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, “/ab+c/gi”
     */
    public val keywordRegex: kotlin.String? = builder.keywordRegex
    /**
     * The pattern description for the customer pattern.
     */
    public val patternDescription: kotlin.String? = builder.patternDescription
    /**
     * The pattern name for the custom pattern.
     */
    public val patternName: kotlin.String = requireNotNull(builder.patternName) { "A non-null value must be provided for patternName" }
    /**
     * The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
     */
    public val patternRegex: kotlin.String = requireNotNull(builder.patternRegex) { "A non-null value must be provided for patternRegex" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.CustomPattern = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomPattern(")
        append("keywordRegex=*** Sensitive Data Redacted ***,")
        append("patternDescription=*** Sensitive Data Redacted ***,")
        append("patternName=*** Sensitive Data Redacted ***,")
        append("patternRegex=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keywordRegex?.hashCode() ?: 0
        result = 31 * result + (patternDescription?.hashCode() ?: 0)
        result = 31 * result + (patternName.hashCode())
        result = 31 * result + (patternRegex.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomPattern

        if (keywordRegex != other.keywordRegex) return false
        if (patternDescription != other.patternDescription) return false
        if (patternName != other.patternName) return false
        if (patternRegex != other.patternRegex) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.CustomPattern = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, “/ab+c/gi”
         */
        public var keywordRegex: kotlin.String? = null
        /**
         * The pattern description for the customer pattern.
         */
        public var patternDescription: kotlin.String? = null
        /**
         * The pattern name for the custom pattern.
         */
        public var patternName: kotlin.String? = null
        /**
         * The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
         */
        public var patternRegex: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.CustomPattern) : this() {
            this.keywordRegex = x.keywordRegex
            this.patternDescription = x.patternDescription
            this.patternName = x.patternName
            this.patternRegex = x.patternRegex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.CustomPattern = CustomPattern(this)

        internal fun correctErrors(): Builder {
            if (patternName == null) patternName = ""
            if (patternRegex == null) patternRegex = ""
            return this
        }
    }
}
