// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateBrowserSettingsRequest private constructor(builder: Builder) {
    /**
     * Additional encryption context of the browser settings.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     */
    public val browserPolicy: kotlin.String? = builder.browserPolicy
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.
     *
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The custom managed key of the browser settings.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBrowserSettingsRequest(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("browserPolicy=*** Sensitive Data Redacted ***,")
        append("clientToken=$clientToken,")
        append("customerManagedKey=$customerManagedKey,")
        append("tags=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (browserPolicy?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBrowserSettingsRequest

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (browserPolicy != other.browserPolicy) return false
        if (clientToken != other.clientToken) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional encryption context of the browser settings.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         */
        public var browserPolicy: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.
         *
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The custom managed key of the browser settings.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * The tags to add to the browser settings resource. A tag is a key-value pair.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsRequest) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.browserPolicy = x.browserPolicy
            this.clientToken = x.clientToken
            this.customerManagedKey = x.customerManagedKey
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsRequest = CreateBrowserSettingsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
