// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.paginators

import aws.sdk.kotlin.services.workspacesweb.WorkSpacesWebClient
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListSessionsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListSessionsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.SessionSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBrowserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBrowserSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBrowserSettingsResponse]
 */
public fun WorkSpacesWebClient.listBrowserSettingsPaginated(initialRequest: ListBrowserSettingsRequest = ListBrowserSettingsRequest { }): Flow<ListBrowserSettingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBrowserSettingsPaginated.listBrowserSettings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBrowserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBrowserSettingsResponse]
 */
public fun WorkSpacesWebClient.listBrowserSettingsPaginated(block: ListBrowserSettingsRequest.Builder.() -> Unit): Flow<ListBrowserSettingsResponse> =
    listBrowserSettingsPaginated(ListBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentityProvidersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
public fun WorkSpacesWebClient.listIdentityProvidersPaginated(initialRequest: ListIdentityProvidersRequest): Flow<ListIdentityProvidersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentityProvidersPaginated.listIdentityProviders(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentityProvidersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentityProvidersResponse]
 */
public fun WorkSpacesWebClient.listIdentityProvidersPaginated(block: ListIdentityProvidersRequest.Builder.() -> Unit): Flow<ListIdentityProvidersResponse> =
    listIdentityProvidersPaginated(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListIpAccessSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIpAccessSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIpAccessSettingsResponse]
 */
public fun WorkSpacesWebClient.listIpAccessSettingsPaginated(initialRequest: ListIpAccessSettingsRequest = ListIpAccessSettingsRequest { }): Flow<ListIpAccessSettingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIpAccessSettingsPaginated.listIpAccessSettings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIpAccessSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIpAccessSettingsResponse]
 */
public fun WorkSpacesWebClient.listIpAccessSettingsPaginated(block: ListIpAccessSettingsRequest.Builder.() -> Unit): Flow<ListIpAccessSettingsResponse> =
    listIpAccessSettingsPaginated(ListIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNetworkSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNetworkSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworkSettingsResponse]
 */
public fun WorkSpacesWebClient.listNetworkSettingsPaginated(initialRequest: ListNetworkSettingsRequest = ListNetworkSettingsRequest { }): Flow<ListNetworkSettingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNetworkSettingsPaginated.listNetworkSettings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListNetworkSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNetworkSettingsResponse]
 */
public fun WorkSpacesWebClient.listNetworkSettingsPaginated(block: ListNetworkSettingsRequest.Builder.() -> Unit): Flow<ListNetworkSettingsResponse> =
    listNetworkSettingsPaginated(ListNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPortalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPortalsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortalsResponse]
 */
public fun WorkSpacesWebClient.listPortalsPaginated(initialRequest: ListPortalsRequest = ListPortalsRequest { }): Flow<ListPortalsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPortalsPaginated.listPortals(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPortalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPortalsResponse]
 */
public fun WorkSpacesWebClient.listPortalsPaginated(block: ListPortalsRequest.Builder.() -> Unit): Flow<ListPortalsResponse> =
    listPortalsPaginated(ListPortalsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSessionsResponse]
 */
public fun WorkSpacesWebClient.listSessionsPaginated(initialRequest: ListSessionsRequest): Flow<ListSessionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSessionsPaginated.listSessions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSessionsResponse]
 */
public fun WorkSpacesWebClient.listSessionsPaginated(block: ListSessionsRequest.Builder.() -> Unit): Flow<ListSessionsResponse> =
    listSessionsPaginated(ListSessionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSessionsPaginated]
 * to access the nested member [SessionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SessionSummary]
 */
@JvmName("listSessionsResponseSessionSummary")
public fun Flow<ListSessionsResponse>.sessions(): Flow<SessionSummary> =
    transform() { response ->
        response.sessions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTrustStoreCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrustStoreCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoreCertificatesResponse]
 */
public fun WorkSpacesWebClient.listTrustStoreCertificatesPaginated(initialRequest: ListTrustStoreCertificatesRequest): Flow<ListTrustStoreCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrustStoreCertificatesPaginated.listTrustStoreCertificates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrustStoreCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoreCertificatesResponse]
 */
public fun WorkSpacesWebClient.listTrustStoreCertificatesPaginated(block: ListTrustStoreCertificatesRequest.Builder.() -> Unit): Flow<ListTrustStoreCertificatesResponse> =
    listTrustStoreCertificatesPaginated(ListTrustStoreCertificatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTrustStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTrustStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoresResponse]
 */
public fun WorkSpacesWebClient.listTrustStoresPaginated(initialRequest: ListTrustStoresRequest = ListTrustStoresRequest { }): Flow<ListTrustStoresResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTrustStoresPaginated.listTrustStores(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTrustStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTrustStoresResponse]
 */
public fun WorkSpacesWebClient.listTrustStoresPaginated(block: ListTrustStoresRequest.Builder.() -> Unit): Flow<ListTrustStoresResponse> =
    listTrustStoresPaginated(ListTrustStoresRequest.Builder().apply(block).build())

/**
 * Paginate over [ListUserAccessLoggingSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserAccessLoggingSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserAccessLoggingSettingsResponse]
 */
public fun WorkSpacesWebClient.listUserAccessLoggingSettingsPaginated(initialRequest: ListUserAccessLoggingSettingsRequest = ListUserAccessLoggingSettingsRequest { }): Flow<ListUserAccessLoggingSettingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserAccessLoggingSettingsPaginated.listUserAccessLoggingSettings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUserAccessLoggingSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserAccessLoggingSettingsResponse]
 */
public fun WorkSpacesWebClient.listUserAccessLoggingSettingsPaginated(block: ListUserAccessLoggingSettingsRequest.Builder.() -> Unit): Flow<ListUserAccessLoggingSettingsResponse> =
    listUserAccessLoggingSettingsPaginated(ListUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListUserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUserSettingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserSettingsResponse]
 */
public fun WorkSpacesWebClient.listUserSettingsPaginated(initialRequest: ListUserSettingsRequest = ListUserSettingsRequest { }): Flow<ListUserSettingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUserSettingsPaginated.listUserSettings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUserSettingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUserSettingsResponse]
 */
public fun WorkSpacesWebClient.listUserSettingsPaginated(block: ListUserSettingsRequest.Builder.() -> Unit): Flow<ListUserSettingsResponse> =
    listUserSettingsPaginated(ListUserSettingsRequest.Builder().apply(block).build())
