// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.
 */
public class UserSettings private constructor(builder: Builder) {
    /**
     * The additional encryption context of the user settings.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * A list of web portal ARNs that this user settings is associated with.
     */
    public val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
     */
    public val cookieSynchronizationConfiguration: aws.sdk.kotlin.services.workspacesweb.model.CookieSynchronizationConfiguration? = builder.cookieSynchronizationConfiguration
    /**
     * Specifies whether the user can copy text from the streaming session to the local device.
     */
    public val copyAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.copyAllowed
    /**
     * The customer managed key used to encrypt sensitive information in the user settings.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * Specifies whether the user can use deep links that open automatically when connecting to a session.
     */
    public val deepLinkAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.deepLinkAllowed
    /**
     * The amount of time that a streaming session remains active after users disconnect.
     */
    public val disconnectTimeoutInMinutes: kotlin.Int? = builder.disconnectTimeoutInMinutes
    /**
     * Specifies whether the user can download files from the streaming session to the local device.
     */
    public val downloadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.downloadAllowed
    /**
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
     */
    public val idleDisconnectTimeoutInMinutes: kotlin.Int? = builder.idleDisconnectTimeoutInMinutes
    /**
     * Specifies whether the user can paste text from the local device to the streaming session.
     */
    public val pasteAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.pasteAllowed
    /**
     * Specifies whether the user can print to the local device.
     */
    public val printAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.printAllowed
    /**
     * Specifies whether the user can upload files from the local device to the streaming session.
     */
    public val uploadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = builder.uploadAllowed
    /**
     * The ARN of the user settings.
     */
    public val userSettingsArn: kotlin.String = requireNotNull(builder.userSettingsArn) { "A non-null value must be provided for userSettingsArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.UserSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserSettings(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("associatedPortalArns=$associatedPortalArns,")
        append("cookieSynchronizationConfiguration=*** Sensitive Data Redacted ***,")
        append("copyAllowed=$copyAllowed,")
        append("customerManagedKey=$customerManagedKey,")
        append("deepLinkAllowed=$deepLinkAllowed,")
        append("disconnectTimeoutInMinutes=$disconnectTimeoutInMinutes,")
        append("downloadAllowed=$downloadAllowed,")
        append("idleDisconnectTimeoutInMinutes=$idleDisconnectTimeoutInMinutes,")
        append("pasteAllowed=$pasteAllowed,")
        append("printAllowed=$printAllowed,")
        append("uploadAllowed=$uploadAllowed,")
        append("userSettingsArn=$userSettingsArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (associatedPortalArns?.hashCode() ?: 0)
        result = 31 * result + (cookieSynchronizationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyAllowed?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (deepLinkAllowed?.hashCode() ?: 0)
        result = 31 * result + (disconnectTimeoutInMinutes ?: 0)
        result = 31 * result + (downloadAllowed?.hashCode() ?: 0)
        result = 31 * result + (idleDisconnectTimeoutInMinutes ?: 0)
        result = 31 * result + (pasteAllowed?.hashCode() ?: 0)
        result = 31 * result + (printAllowed?.hashCode() ?: 0)
        result = 31 * result + (uploadAllowed?.hashCode() ?: 0)
        result = 31 * result + (userSettingsArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserSettings

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (associatedPortalArns != other.associatedPortalArns) return false
        if (cookieSynchronizationConfiguration != other.cookieSynchronizationConfiguration) return false
        if (copyAllowed != other.copyAllowed) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (deepLinkAllowed != other.deepLinkAllowed) return false
        if (disconnectTimeoutInMinutes != other.disconnectTimeoutInMinutes) return false
        if (downloadAllowed != other.downloadAllowed) return false
        if (idleDisconnectTimeoutInMinutes != other.idleDisconnectTimeoutInMinutes) return false
        if (pasteAllowed != other.pasteAllowed) return false
        if (printAllowed != other.printAllowed) return false
        if (uploadAllowed != other.uploadAllowed) return false
        if (userSettingsArn != other.userSettingsArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.UserSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The additional encryption context of the user settings.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * A list of web portal ARNs that this user settings is associated with.
         */
        public var associatedPortalArns: List<String>? = null
        /**
         * The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
         */
        public var cookieSynchronizationConfiguration: aws.sdk.kotlin.services.workspacesweb.model.CookieSynchronizationConfiguration? = null
        /**
         * Specifies whether the user can copy text from the streaming session to the local device.
         */
        public var copyAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * The customer managed key used to encrypt sensitive information in the user settings.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * Specifies whether the user can use deep links that open automatically when connecting to a session.
         */
        public var deepLinkAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * The amount of time that a streaming session remains active after users disconnect.
         */
        public var disconnectTimeoutInMinutes: kotlin.Int? = null
        /**
         * Specifies whether the user can download files from the streaming session to the local device.
         */
        public var downloadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
         */
        public var idleDisconnectTimeoutInMinutes: kotlin.Int? = null
        /**
         * Specifies whether the user can paste text from the local device to the streaming session.
         */
        public var pasteAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * Specifies whether the user can print to the local device.
         */
        public var printAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * Specifies whether the user can upload files from the local device to the streaming session.
         */
        public var uploadAllowed: aws.sdk.kotlin.services.workspacesweb.model.EnabledType? = null
        /**
         * The ARN of the user settings.
         */
        public var userSettingsArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.UserSettings) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.associatedPortalArns = x.associatedPortalArns
            this.cookieSynchronizationConfiguration = x.cookieSynchronizationConfiguration
            this.copyAllowed = x.copyAllowed
            this.customerManagedKey = x.customerManagedKey
            this.deepLinkAllowed = x.deepLinkAllowed
            this.disconnectTimeoutInMinutes = x.disconnectTimeoutInMinutes
            this.downloadAllowed = x.downloadAllowed
            this.idleDisconnectTimeoutInMinutes = x.idleDisconnectTimeoutInMinutes
            this.pasteAllowed = x.pasteAllowed
            this.printAllowed = x.printAllowed
            this.uploadAllowed = x.uploadAllowed
            this.userSettingsArn = x.userSettingsArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.UserSettings = UserSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspacesweb.model.CookieSynchronizationConfiguration] inside the given [block]
         */
        public fun cookieSynchronizationConfiguration(block: aws.sdk.kotlin.services.workspacesweb.model.CookieSynchronizationConfiguration.Builder.() -> kotlin.Unit) {
            this.cookieSynchronizationConfiguration = aws.sdk.kotlin.services.workspacesweb.model.CookieSynchronizationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (userSettingsArn == null) userSettingsArn = ""
            return this
        }
    }
}
