// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateIdentityProviderRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request.
     *
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ARN of the identity provider.
     */
    public val identityProviderArn: kotlin.String? = builder.identityProviderArn
    /**
     * The details of the identity provider. The following list describes the provider detail keys for each identity provider type.
     * + For Google and Login with Amazon:
     *    + `client_id`
     *    + `client_secret`
     *    + `authorize_scopes`
     * + For Facebook:
     *    + `client_id`
     *    + `client_secret`
     *    + `authorize_scopes`
     *    + `api_version`
     * + For Sign in with Apple:
     *    + `client_id`
     *    + `team_id`
     *    + `key_id`
     *    + `private_key`
     *    + `authorize_scopes`
     * + For OIDC providers:
     *    + `client_id`
     *    + `client_secret`
     *    + `attributes_request_method`
     *    + `oidc_issuer`
     *    + `authorize_scopes`
     *    + `authorize_url`*if not available from discovery URL specified by `oidc_issuer` key*
     *    + `token_url`*if not available from discovery URL specified by `oidc_issuer` key*
     *    + `attributes_url`*if not available from discovery URL specified by `oidc_issuer` key*
     *    + `jwks_uri`*if not available from discovery URL specified by `oidc_issuer` key*
     * + For SAML providers:
     *    + `MetadataFile` OR `MetadataURL`
     *    + `IDPSignout` (boolean) *optional*
     *    + `IDPInit` (boolean) *optional*
     *    + `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
     *    + `EncryptedResponses` (boolean) *optional*
     */
    public val identityProviderDetails: Map<String, String>? = builder.identityProviderDetails
    /**
     * The name of the identity provider.
     */
    public val identityProviderName: kotlin.String? = builder.identityProviderName
    /**
     * The type of the identity provider.
     */
    public val identityProviderType: aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType? = builder.identityProviderType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIdentityProviderRequest(")
        append("clientToken=$clientToken,")
        append("identityProviderArn=$identityProviderArn,")
        append("identityProviderDetails=*** Sensitive Data Redacted ***,")
        append("identityProviderName=*** Sensitive Data Redacted ***,")
        append("identityProviderType=$identityProviderType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (identityProviderArn?.hashCode() ?: 0)
        result = 31 * result + (identityProviderDetails?.hashCode() ?: 0)
        result = 31 * result + (identityProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityProviderType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIdentityProviderRequest

        if (clientToken != other.clientToken) return false
        if (identityProviderArn != other.identityProviderArn) return false
        if (identityProviderDetails != other.identityProviderDetails) return false
        if (identityProviderName != other.identityProviderName) return false
        if (identityProviderType != other.identityProviderType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token return the result from the original successful request.
         *
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ARN of the identity provider.
         */
        public var identityProviderArn: kotlin.String? = null
        /**
         * The details of the identity provider. The following list describes the provider detail keys for each identity provider type.
         * + For Google and Login with Amazon:
         *    + `client_id`
         *    + `client_secret`
         *    + `authorize_scopes`
         * + For Facebook:
         *    + `client_id`
         *    + `client_secret`
         *    + `authorize_scopes`
         *    + `api_version`
         * + For Sign in with Apple:
         *    + `client_id`
         *    + `team_id`
         *    + `key_id`
         *    + `private_key`
         *    + `authorize_scopes`
         * + For OIDC providers:
         *    + `client_id`
         *    + `client_secret`
         *    + `attributes_request_method`
         *    + `oidc_issuer`
         *    + `authorize_scopes`
         *    + `authorize_url`*if not available from discovery URL specified by `oidc_issuer` key*
         *    + `token_url`*if not available from discovery URL specified by `oidc_issuer` key*
         *    + `attributes_url`*if not available from discovery URL specified by `oidc_issuer` key*
         *    + `jwks_uri`*if not available from discovery URL specified by `oidc_issuer` key*
         * + For SAML providers:
         *    + `MetadataFile` OR `MetadataURL`
         *    + `IDPSignout` (boolean) *optional*
         *    + `IDPInit` (boolean) *optional*
         *    + `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
         *    + `EncryptedResponses` (boolean) *optional*
         */
        public var identityProviderDetails: Map<String, String>? = null
        /**
         * The name of the identity provider.
         */
        public var identityProviderName: kotlin.String? = null
        /**
         * The type of the identity provider.
         */
        public var identityProviderType: aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest) : this() {
            this.clientToken = x.clientToken
            this.identityProviderArn = x.identityProviderArn
            this.identityProviderDetails = x.identityProviderDetails
            this.identityProviderName = x.identityProviderName
            this.identityProviderType = x.identityProviderType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest = UpdateIdentityProviderRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
