// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.
 */
public class TrustStore private constructor(builder: Builder) {
    /**
     * A list of web portal ARNs that this trust store is associated with.
     */
    public val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The ARN of the trust store.
     */
    public val trustStoreArn: kotlin.String = requireNotNull(builder.trustStoreArn) { "A non-null value must be provided for trustStoreArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.TrustStore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustStore(")
        append("associatedPortalArns=$associatedPortalArns,")
        append("trustStoreArn=$trustStoreArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedPortalArns?.hashCode() ?: 0
        result = 31 * result + (trustStoreArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustStore

        if (associatedPortalArns != other.associatedPortalArns) return false
        if (trustStoreArn != other.trustStoreArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.TrustStore = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of web portal ARNs that this trust store is associated with.
         */
        public var associatedPortalArns: List<String>? = null
        /**
         * The ARN of the trust store.
         */
        public var trustStoreArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.TrustStore) : this() {
            this.associatedPortalArns = x.associatedPortalArns
            this.trustStoreArn = x.trustStoreArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.TrustStore = TrustStore(this)

        internal fun correctErrors(): Builder {
            if (trustStoreArn == null) trustStoreArn = ""
            return this
        }
    }
}
