// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The IP access settings resource that can be associated with a web portal.
 */
public class IpAccessSettings private constructor(builder: Builder) {
    /**
     * The additional encryption context of the IP access settings.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * A list of web portal ARNs that this IP access settings resource is associated with.
     */
    public val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The creation date timestamp of the IP access settings.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The customer managed key used to encrypt sensitive information in the IP access settings.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * The description of the IP access settings.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name of the IP access settings.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The ARN of the IP access settings resource.
     */
    public val ipAccessSettingsArn: kotlin.String = requireNotNull(builder.ipAccessSettingsArn) { "A non-null value must be provided for ipAccessSettingsArn" }
    /**
     * The IP rules of the IP access settings.
     */
    public val ipRules: List<IpRule>? = builder.ipRules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.IpAccessSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpAccessSettings(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("associatedPortalArns=$associatedPortalArns,")
        append("creationDate=$creationDate,")
        append("customerManagedKey=$customerManagedKey,")
        append("description=*** Sensitive Data Redacted ***,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("ipAccessSettingsArn=$ipAccessSettingsArn,")
        append("ipRules=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (associatedPortalArns?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (ipAccessSettingsArn.hashCode())
        result = 31 * result + (ipRules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpAccessSettings

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (associatedPortalArns != other.associatedPortalArns) return false
        if (creationDate != other.creationDate) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (ipAccessSettingsArn != other.ipAccessSettingsArn) return false
        if (ipRules != other.ipRules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.IpAccessSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The additional encryption context of the IP access settings.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * A list of web portal ARNs that this IP access settings resource is associated with.
         */
        public var associatedPortalArns: List<String>? = null
        /**
         * The creation date timestamp of the IP access settings.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer managed key used to encrypt sensitive information in the IP access settings.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * The description of the IP access settings.
         */
        public var description: kotlin.String? = null
        /**
         * The display name of the IP access settings.
         */
        public var displayName: kotlin.String? = null
        /**
         * The ARN of the IP access settings resource.
         */
        public var ipAccessSettingsArn: kotlin.String? = null
        /**
         * The IP rules of the IP access settings.
         */
        public var ipRules: List<IpRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.IpAccessSettings) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.associatedPortalArns = x.associatedPortalArns
            this.creationDate = x.creationDate
            this.customerManagedKey = x.customerManagedKey
            this.description = x.description
            this.displayName = x.displayName
            this.ipAccessSettingsArn = x.ipAccessSettingsArn
            this.ipRules = x.ipRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.IpAccessSettings = IpAccessSettings(this)

        internal fun correctErrors(): Builder {
            if (ipAccessSettingsArn == null) ipAccessSettingsArn = ""
            return this
        }
    }
}
