// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The identity provider.
 */
public class IdentityProvider private constructor(builder: Builder) {
    /**
     * The ARN of the identity provider.
     */
    public val identityProviderArn: kotlin.String = requireNotNull(builder.identityProviderArn) { "A non-null value must be provided for identityProviderArn" }
    /**
     * The identity provider details. The following list describes the provider detail keys for each identity provider type.
     * + For Google and Login with Amazon:
     *    + `client_id`
     *    + `client_secret`
     *    + `authorize_scopes`
     * + For Facebook:
     *    + `client_id`
     *    + `client_secret`
     *    + `authorize_scopes`
     *    + `api_version`
     * + For Sign in with Apple:
     *    + `client_id`
     *    + `team_id`
     *    + `key_id`
     *    + `private_key`
     *    + `authorize_scopes`
     * + For OIDC providers:
     *    + `client_id`
     *    + `client_secret`
     *    + `attributes_request_method`
     *    + `oidc_issuer`
     *    + `authorize_scopes`
     *    + `authorize_url`*if not available from discovery URL specified by oidc_issuer key*
     *    + `token_url`*if not available from discovery URL specified by oidc_issuer key*
     *    + `attributes_url`*if not available from discovery URL specified by oidc_issuer key*
     *    + `jwks_uri`*if not available from discovery URL specified by oidc_issuer key*
     * + For SAML providers:
     *    + `MetadataFile` OR `MetadataURL`
     *    + `IDPSignout` (boolean) *optional*
     *    + `IDPInit` (boolean) *optional*
     *    + `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
     *    + `EncryptedResponses` (boolean) *optional*
     */
    public val identityProviderDetails: Map<String, String>? = builder.identityProviderDetails
    /**
     * The identity provider name.
     */
    public val identityProviderName: kotlin.String? = builder.identityProviderName
    /**
     * The identity provider type.
     */
    public val identityProviderType: aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType? = builder.identityProviderType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.IdentityProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityProvider(")
        append("identityProviderArn=$identityProviderArn,")
        append("identityProviderDetails=*** Sensitive Data Redacted ***,")
        append("identityProviderName=*** Sensitive Data Redacted ***,")
        append("identityProviderType=$identityProviderType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identityProviderArn.hashCode()
        result = 31 * result + (identityProviderDetails?.hashCode() ?: 0)
        result = 31 * result + (identityProviderName?.hashCode() ?: 0)
        result = 31 * result + (identityProviderType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityProvider

        if (identityProviderArn != other.identityProviderArn) return false
        if (identityProviderDetails != other.identityProviderDetails) return false
        if (identityProviderName != other.identityProviderName) return false
        if (identityProviderType != other.identityProviderType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.IdentityProvider = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the identity provider.
         */
        public var identityProviderArn: kotlin.String? = null
        /**
         * The identity provider details. The following list describes the provider detail keys for each identity provider type.
         * + For Google and Login with Amazon:
         *    + `client_id`
         *    + `client_secret`
         *    + `authorize_scopes`
         * + For Facebook:
         *    + `client_id`
         *    + `client_secret`
         *    + `authorize_scopes`
         *    + `api_version`
         * + For Sign in with Apple:
         *    + `client_id`
         *    + `team_id`
         *    + `key_id`
         *    + `private_key`
         *    + `authorize_scopes`
         * + For OIDC providers:
         *    + `client_id`
         *    + `client_secret`
         *    + `attributes_request_method`
         *    + `oidc_issuer`
         *    + `authorize_scopes`
         *    + `authorize_url`*if not available from discovery URL specified by oidc_issuer key*
         *    + `token_url`*if not available from discovery URL specified by oidc_issuer key*
         *    + `attributes_url`*if not available from discovery URL specified by oidc_issuer key*
         *    + `jwks_uri`*if not available from discovery URL specified by oidc_issuer key*
         * + For SAML providers:
         *    + `MetadataFile` OR `MetadataURL`
         *    + `IDPSignout` (boolean) *optional*
         *    + `IDPInit` (boolean) *optional*
         *    + `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
         *    + `EncryptedResponses` (boolean) *optional*
         */
        public var identityProviderDetails: Map<String, String>? = null
        /**
         * The identity provider name.
         */
        public var identityProviderName: kotlin.String? = null
        /**
         * The identity provider type.
         */
        public var identityProviderType: aws.sdk.kotlin.services.workspacesweb.model.IdentityProviderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.IdentityProvider) : this() {
            this.identityProviderArn = x.identityProviderArn
            this.identityProviderDetails = x.identityProviderDetails
            this.identityProviderName = x.identityProviderName
            this.identityProviderType = x.identityProviderType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.IdentityProvider = IdentityProvider(this)

        internal fun correctErrors(): Builder {
            if (identityProviderArn == null) identityProviderArn = ""
            return this
        }
    }
}
