// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIpAccessSettingsRequest private constructor(builder: Builder) {
    /**
     * Additional encryption context of the IP access settings.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.
     *
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The custom managed key of the IP access settings.
     */
    public val customerManagedKey: kotlin.String? = builder.customerManagedKey
    /**
     * The description of the IP access settings.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name of the IP access settings.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The IP rules of the IP access settings.
     */
    public val ipRules: List<IpRule>? = builder.ipRules
    /**
     * The tags to add to the IP access settings resource. A tag is a key-value pair.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.CreateIpAccessSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIpAccessSettingsRequest(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("clientToken=$clientToken,")
        append("customerManagedKey=$customerManagedKey,")
        append("description=*** Sensitive Data Redacted ***,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("ipRules=*** Sensitive Data Redacted ***,")
        append("tags=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customerManagedKey?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (ipRules?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIpAccessSettingsRequest

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (clientToken != other.clientToken) return false
        if (customerManagedKey != other.customerManagedKey) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (ipRules != other.ipRules) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.CreateIpAccessSettingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional encryption context of the IP access settings.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, subsequent retries with the same client token returns the result from the original successful request.
         *
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The custom managed key of the IP access settings.
         */
        public var customerManagedKey: kotlin.String? = null
        /**
         * The description of the IP access settings.
         */
        public var description: kotlin.String? = null
        /**
         * The display name of the IP access settings.
         */
        public var displayName: kotlin.String? = null
        /**
         * The IP rules of the IP access settings.
         */
        public var ipRules: List<IpRule>? = null
        /**
         * The tags to add to the IP access settings resource. A tag is a key-value pair.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.CreateIpAccessSettingsRequest) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.clientToken = x.clientToken
            this.customerManagedKey = x.customerManagedKey
            this.description = x.description
            this.displayName = x.displayName
            this.ipRules = x.ipRules
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.CreateIpAccessSettingsRequest = CreateIpAccessSettingsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
