// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.workspacesweb.auth.DefaultWorkSpacesWebAuthSchemeProvider
import aws.sdk.kotlin.services.workspacesweb.auth.WorkSpacesWebAuthSchemeProvider
import aws.sdk.kotlin.services.workspacesweb.endpoints.DefaultWorkSpacesWebEndpointProvider
import aws.sdk.kotlin.services.workspacesweb.endpoints.WorkSpacesWebEndpointParameters
import aws.sdk.kotlin.services.workspacesweb.endpoints.WorkSpacesWebEndpointProvider
import aws.sdk.kotlin.services.workspacesweb.model.AssociateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.AssociateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.AssociateUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreatePortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreatePortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.CreateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.CreateUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeletePortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeletePortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DeleteUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DeleteUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.DisassociateUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ExpireSessionRequest
import aws.sdk.kotlin.services.workspacesweb.model.ExpireSessionResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetSessionRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetSessionResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreCertificateRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreCertificateResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.GetUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.GetUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListIdentityProvidersResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListPortalsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListSessionsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListSessionsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoreCertificatesResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListTrustStoresResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.ListUserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.TagResourceRequest
import aws.sdk.kotlin.services.workspacesweb.model.TagResourceResponse
import aws.sdk.kotlin.services.workspacesweb.model.UntagResourceRequest
import aws.sdk.kotlin.services.workspacesweb.model.UntagResourceResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateBrowserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateBrowserSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIdentityProviderResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIpAccessSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateIpAccessSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateNetworkSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateNetworkSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdatePortalRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdatePortalResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateTrustStoreRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateTrustStoreResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateUserAccessLoggingSettingsResponse
import aws.sdk.kotlin.services.workspacesweb.model.UpdateUserSettingsRequest
import aws.sdk.kotlin.services.workspacesweb.model.UpdateUserSettingsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "WorkSpaces Web"
public const val SdkVersion: String = "1.3.53"
public const val ServiceApiVersion: String = "2020-07-08"

/**
 * Amazon WorkSpaces Secure Browser is a low cost, fully managed WorkSpace built specifically to facilitate secure, web-based workloads. WorkSpaces Secure Browser makes it easy for customers to safely provide their employees with access to internal websites and SaaS web applications without the administrative burden of appliances or specialized client software. WorkSpaces Secure Browser provides simple policy tools tailored for user interactions, while offloading common tasks like capacity management, scaling, and maintaining browser images.
 */
public interface WorkSpacesWebClient : SdkClient {
    /**
     * WorkSpacesWebClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, WorkSpacesWebClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "WorkSpacesWeb",
                "WORKSPACES_WEB",
                "workspaces_web",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, WorkSpacesWebClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): WorkSpacesWebClient = DefaultWorkSpacesWebClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: WorkSpacesWebEndpointProvider = builder.endpointProvider ?: DefaultWorkSpacesWebEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: WorkSpacesWebAuthSchemeProvider = builder.authSchemeProvider ?: DefaultWorkSpacesWebAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "WorkSpaces Web"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: WorkSpacesWebEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: WorkSpacesWebAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a browser settings resource with a web portal.
     */
    public suspend fun associateBrowserSettings(input: AssociateBrowserSettingsRequest): AssociateBrowserSettingsResponse

    /**
     * Associates an IP access settings resource with a web portal.
     */
    public suspend fun associateIpAccessSettings(input: AssociateIpAccessSettingsRequest): AssociateIpAccessSettingsResponse

    /**
     * Associates a network settings resource with a web portal.
     */
    public suspend fun associateNetworkSettings(input: AssociateNetworkSettingsRequest): AssociateNetworkSettingsResponse

    /**
     * Associates a trust store with a web portal.
     */
    public suspend fun associateTrustStore(input: AssociateTrustStoreRequest): AssociateTrustStoreResponse

    /**
     * Associates a user access logging settings resource with a web portal.
     */
    public suspend fun associateUserAccessLoggingSettings(input: AssociateUserAccessLoggingSettingsRequest): AssociateUserAccessLoggingSettingsResponse

    /**
     * Associates a user settings resource with a web portal.
     */
    public suspend fun associateUserSettings(input: AssociateUserSettingsRequest): AssociateUserSettingsResponse

    /**
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     */
    public suspend fun createBrowserSettings(input: CreateBrowserSettingsRequest): CreateBrowserSettingsResponse

    /**
     * Creates an identity provider resource that is then associated with a web portal.
     */
    public suspend fun createIdentityProvider(input: CreateIdentityProviderRequest): CreateIdentityProviderResponse

    /**
     * Creates an IP access settings resource that can be associated with a web portal.
     */
    public suspend fun createIpAccessSettings(input: CreateIpAccessSettingsRequest): CreateIpAccessSettingsResponse

    /**
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.
     */
    public suspend fun createNetworkSettings(input: CreateNetworkSettingsRequest): CreateNetworkSettingsResponse

    /**
     * Creates a web portal.
     */
    public suspend fun createPortal(input: CreatePortalRequest = CreatePortalRequest { }): CreatePortalResponse

    /**
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     */
    public suspend fun createTrustStore(input: CreateTrustStoreRequest): CreateTrustStoreResponse

    /**
     * Creates a user access logging settings resource that can be associated with a web portal.
     */
    public suspend fun createUserAccessLoggingSettings(input: CreateUserAccessLoggingSettingsRequest): CreateUserAccessLoggingSettingsResponse

    /**
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.
     */
    public suspend fun createUserSettings(input: CreateUserSettingsRequest): CreateUserSettingsResponse

    /**
     * Deletes browser settings.
     */
    public suspend fun deleteBrowserSettings(input: DeleteBrowserSettingsRequest): DeleteBrowserSettingsResponse

    /**
     * Deletes the identity provider.
     */
    public suspend fun deleteIdentityProvider(input: DeleteIdentityProviderRequest): DeleteIdentityProviderResponse

    /**
     * Deletes IP access settings.
     */
    public suspend fun deleteIpAccessSettings(input: DeleteIpAccessSettingsRequest): DeleteIpAccessSettingsResponse

    /**
     * Deletes network settings.
     */
    public suspend fun deleteNetworkSettings(input: DeleteNetworkSettingsRequest): DeleteNetworkSettingsResponse

    /**
     * Deletes a web portal.
     */
    public suspend fun deletePortal(input: DeletePortalRequest): DeletePortalResponse

    /**
     * Deletes the trust store.
     */
    public suspend fun deleteTrustStore(input: DeleteTrustStoreRequest): DeleteTrustStoreResponse

    /**
     * Deletes user access logging settings.
     */
    public suspend fun deleteUserAccessLoggingSettings(input: DeleteUserAccessLoggingSettingsRequest): DeleteUserAccessLoggingSettingsResponse

    /**
     * Deletes user settings.
     */
    public suspend fun deleteUserSettings(input: DeleteUserSettingsRequest): DeleteUserSettingsResponse

    /**
     * Disassociates browser settings from a web portal.
     */
    public suspend fun disassociateBrowserSettings(input: DisassociateBrowserSettingsRequest): DisassociateBrowserSettingsResponse

    /**
     * Disassociates IP access settings from a web portal.
     */
    public suspend fun disassociateIpAccessSettings(input: DisassociateIpAccessSettingsRequest): DisassociateIpAccessSettingsResponse

    /**
     * Disassociates network settings from a web portal.
     */
    public suspend fun disassociateNetworkSettings(input: DisassociateNetworkSettingsRequest): DisassociateNetworkSettingsResponse

    /**
     * Disassociates a trust store from a web portal.
     */
    public suspend fun disassociateTrustStore(input: DisassociateTrustStoreRequest): DisassociateTrustStoreResponse

    /**
     * Disassociates user access logging settings from a web portal.
     */
    public suspend fun disassociateUserAccessLoggingSettings(input: DisassociateUserAccessLoggingSettingsRequest): DisassociateUserAccessLoggingSettingsResponse

    /**
     * Disassociates user settings from a web portal.
     */
    public suspend fun disassociateUserSettings(input: DisassociateUserSettingsRequest): DisassociateUserSettingsResponse

    /**
     * Expires an active secure browser session.
     */
    public suspend fun expireSession(input: ExpireSessionRequest): ExpireSessionResponse

    /**
     * Gets browser settings.
     */
    public suspend fun getBrowserSettings(input: GetBrowserSettingsRequest): GetBrowserSettingsResponse

    /**
     * Gets the identity provider.
     */
    public suspend fun getIdentityProvider(input: GetIdentityProviderRequest): GetIdentityProviderResponse

    /**
     * Gets the IP access settings.
     */
    public suspend fun getIpAccessSettings(input: GetIpAccessSettingsRequest): GetIpAccessSettingsResponse

    /**
     * Gets the network settings.
     */
    public suspend fun getNetworkSettings(input: GetNetworkSettingsRequest): GetNetworkSettingsResponse

    /**
     * Gets the web portal.
     */
    public suspend fun getPortal(input: GetPortalRequest): GetPortalResponse

    /**
     * Gets the service provider metadata.
     */
    public suspend fun getPortalServiceProviderMetadata(input: GetPortalServiceProviderMetadataRequest): GetPortalServiceProviderMetadataResponse

    /**
     * Gets information for a secure browser session.
     */
    public suspend fun getSession(input: GetSessionRequest): GetSessionResponse

    /**
     * Gets the trust store.
     */
    public suspend fun getTrustStore(input: GetTrustStoreRequest): GetTrustStoreResponse

    /**
     * Gets the trust store certificate.
     */
    public suspend fun getTrustStoreCertificate(input: GetTrustStoreCertificateRequest): GetTrustStoreCertificateResponse

    /**
     * Gets user access logging settings.
     */
    public suspend fun getUserAccessLoggingSettings(input: GetUserAccessLoggingSettingsRequest): GetUserAccessLoggingSettingsResponse

    /**
     * Gets user settings.
     */
    public suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse

    /**
     * Retrieves a list of browser settings.
     */
    public suspend fun listBrowserSettings(input: ListBrowserSettingsRequest = ListBrowserSettingsRequest { }): ListBrowserSettingsResponse

    /**
     * Retrieves a list of identity providers for a specific web portal.
     */
    public suspend fun listIdentityProviders(input: ListIdentityProvidersRequest): ListIdentityProvidersResponse

    /**
     * Retrieves a list of IP access settings.
     */
    public suspend fun listIpAccessSettings(input: ListIpAccessSettingsRequest = ListIpAccessSettingsRequest { }): ListIpAccessSettingsResponse

    /**
     * Retrieves a list of network settings.
     */
    public suspend fun listNetworkSettings(input: ListNetworkSettingsRequest = ListNetworkSettingsRequest { }): ListNetworkSettingsResponse

    /**
     * Retrieves a list or web portals.
     */
    public suspend fun listPortals(input: ListPortalsRequest = ListPortalsRequest { }): ListPortalsResponse

    /**
     * Lists information for multiple secure browser sessions from a specific portal.
     */
    public suspend fun listSessions(input: ListSessionsRequest): ListSessionsResponse

    /**
     * Retrieves a list of tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of trust store certificates.
     */
    public suspend fun listTrustStoreCertificates(input: ListTrustStoreCertificatesRequest): ListTrustStoreCertificatesResponse

    /**
     * Retrieves a list of trust stores.
     */
    public suspend fun listTrustStores(input: ListTrustStoresRequest = ListTrustStoresRequest { }): ListTrustStoresResponse

    /**
     * Retrieves a list of user access logging settings.
     */
    public suspend fun listUserAccessLoggingSettings(input: ListUserAccessLoggingSettingsRequest = ListUserAccessLoggingSettingsRequest { }): ListUserAccessLoggingSettingsResponse

    /**
     * Retrieves a list of user settings.
     */
    public suspend fun listUserSettings(input: ListUserSettingsRequest = ListUserSettingsRequest { }): ListUserSettingsResponse

    /**
     * Adds or overwrites one or more tags for the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates browser settings.
     */
    public suspend fun updateBrowserSettings(input: UpdateBrowserSettingsRequest): UpdateBrowserSettingsResponse

    /**
     * Updates the identity provider.
     */
    public suspend fun updateIdentityProvider(input: UpdateIdentityProviderRequest): UpdateIdentityProviderResponse

    /**
     * Updates IP access settings.
     */
    public suspend fun updateIpAccessSettings(input: UpdateIpAccessSettingsRequest): UpdateIpAccessSettingsResponse

    /**
     * Updates network settings.
     */
    public suspend fun updateNetworkSettings(input: UpdateNetworkSettingsRequest): UpdateNetworkSettingsResponse

    /**
     * Updates a web portal.
     */
    public suspend fun updatePortal(input: UpdatePortalRequest): UpdatePortalResponse

    /**
     * Updates the trust store.
     */
    public suspend fun updateTrustStore(input: UpdateTrustStoreRequest): UpdateTrustStoreResponse

    /**
     * Updates the user access logging settings.
     */
    public suspend fun updateUserAccessLoggingSettings(input: UpdateUserAccessLoggingSettingsRequest): UpdateUserAccessLoggingSettingsResponse

    /**
     * Updates the user settings.
     */
    public suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun WorkSpacesWebClient.withConfig(block: WorkSpacesWebClient.Config.Builder.() -> Unit): WorkSpacesWebClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultWorkSpacesWebClient(newConfig)
}

/**
 * Associates a browser settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateBrowserSettings(crossinline block: AssociateBrowserSettingsRequest.Builder.() -> Unit): AssociateBrowserSettingsResponse = associateBrowserSettings(AssociateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Associates an IP access settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateIpAccessSettings(crossinline block: AssociateIpAccessSettingsRequest.Builder.() -> Unit): AssociateIpAccessSettingsResponse = associateIpAccessSettings(AssociateIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Associates a network settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateNetworkSettings(crossinline block: AssociateNetworkSettingsRequest.Builder.() -> Unit): AssociateNetworkSettingsResponse = associateNetworkSettings(AssociateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Associates a trust store with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateTrustStore(crossinline block: AssociateTrustStoreRequest.Builder.() -> Unit): AssociateTrustStoreResponse = associateTrustStore(AssociateTrustStoreRequest.Builder().apply(block).build())

/**
 * Associates a user access logging settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateUserAccessLoggingSettings(crossinline block: AssociateUserAccessLoggingSettingsRequest.Builder.() -> Unit): AssociateUserAccessLoggingSettingsResponse = associateUserAccessLoggingSettings(AssociateUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Associates a user settings resource with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.associateUserSettings(crossinline block: AssociateUserSettingsRequest.Builder.() -> Unit): AssociateUserSettingsResponse = associateUserSettings(AssociateUserSettingsRequest.Builder().apply(block).build())

/**
 * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal, browser settings control how the browser will behave once a user starts a streaming session for the web portal.
 */
public suspend inline fun WorkSpacesWebClient.createBrowserSettings(crossinline block: CreateBrowserSettingsRequest.Builder.() -> Unit): CreateBrowserSettingsResponse = createBrowserSettings(CreateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Creates an identity provider resource that is then associated with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.createIdentityProvider(crossinline block: CreateIdentityProviderRequest.Builder.() -> Unit): CreateIdentityProviderResponse = createIdentityProvider(CreateIdentityProviderRequest.Builder().apply(block).build())

/**
 * Creates an IP access settings resource that can be associated with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.createIpAccessSettings(crossinline block: CreateIpAccessSettingsRequest.Builder.() -> Unit): CreateIpAccessSettingsResponse = createIpAccessSettings(CreateIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.
 */
public suspend inline fun WorkSpacesWebClient.createNetworkSettings(crossinline block: CreateNetworkSettingsRequest.Builder.() -> Unit): CreateNetworkSettingsResponse = createNetworkSettings(CreateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Creates a web portal.
 */
public suspend inline fun WorkSpacesWebClient.createPortal(crossinline block: CreatePortalRequest.Builder.() -> Unit): CreatePortalResponse = createPortal(CreatePortalRequest.Builder().apply(block).build())

/**
 * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.
 */
public suspend inline fun WorkSpacesWebClient.createTrustStore(crossinline block: CreateTrustStoreRequest.Builder.() -> Unit): CreateTrustStoreResponse = createTrustStore(CreateTrustStoreRequest.Builder().apply(block).build())

/**
 * Creates a user access logging settings resource that can be associated with a web portal.
 */
public suspend inline fun WorkSpacesWebClient.createUserAccessLoggingSettings(crossinline block: CreateUserAccessLoggingSettingsRequest.Builder.() -> Unit): CreateUserAccessLoggingSettingsResponse = createUserAccessLoggingSettings(CreateUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.
 */
public suspend inline fun WorkSpacesWebClient.createUserSettings(crossinline block: CreateUserSettingsRequest.Builder.() -> Unit): CreateUserSettingsResponse = createUserSettings(CreateUserSettingsRequest.Builder().apply(block).build())

/**
 * Deletes browser settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteBrowserSettings(crossinline block: DeleteBrowserSettingsRequest.Builder.() -> Unit): DeleteBrowserSettingsResponse = deleteBrowserSettings(DeleteBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Deletes the identity provider.
 */
public suspend inline fun WorkSpacesWebClient.deleteIdentityProvider(crossinline block: DeleteIdentityProviderRequest.Builder.() -> Unit): DeleteIdentityProviderResponse = deleteIdentityProvider(DeleteIdentityProviderRequest.Builder().apply(block).build())

/**
 * Deletes IP access settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteIpAccessSettings(crossinline block: DeleteIpAccessSettingsRequest.Builder.() -> Unit): DeleteIpAccessSettingsResponse = deleteIpAccessSettings(DeleteIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Deletes network settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteNetworkSettings(crossinline block: DeleteNetworkSettingsRequest.Builder.() -> Unit): DeleteNetworkSettingsResponse = deleteNetworkSettings(DeleteNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Deletes a web portal.
 */
public suspend inline fun WorkSpacesWebClient.deletePortal(crossinline block: DeletePortalRequest.Builder.() -> Unit): DeletePortalResponse = deletePortal(DeletePortalRequest.Builder().apply(block).build())

/**
 * Deletes the trust store.
 */
public suspend inline fun WorkSpacesWebClient.deleteTrustStore(crossinline block: DeleteTrustStoreRequest.Builder.() -> Unit): DeleteTrustStoreResponse = deleteTrustStore(DeleteTrustStoreRequest.Builder().apply(block).build())

/**
 * Deletes user access logging settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteUserAccessLoggingSettings(crossinline block: DeleteUserAccessLoggingSettingsRequest.Builder.() -> Unit): DeleteUserAccessLoggingSettingsResponse = deleteUserAccessLoggingSettings(DeleteUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Deletes user settings.
 */
public suspend inline fun WorkSpacesWebClient.deleteUserSettings(crossinline block: DeleteUserSettingsRequest.Builder.() -> Unit): DeleteUserSettingsResponse = deleteUserSettings(DeleteUserSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates browser settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateBrowserSettings(crossinline block: DisassociateBrowserSettingsRequest.Builder.() -> Unit): DisassociateBrowserSettingsResponse = disassociateBrowserSettings(DisassociateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates IP access settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateIpAccessSettings(crossinline block: DisassociateIpAccessSettingsRequest.Builder.() -> Unit): DisassociateIpAccessSettingsResponse = disassociateIpAccessSettings(DisassociateIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates network settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateNetworkSettings(crossinline block: DisassociateNetworkSettingsRequest.Builder.() -> Unit): DisassociateNetworkSettingsResponse = disassociateNetworkSettings(DisassociateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates a trust store from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateTrustStore(crossinline block: DisassociateTrustStoreRequest.Builder.() -> Unit): DisassociateTrustStoreResponse = disassociateTrustStore(DisassociateTrustStoreRequest.Builder().apply(block).build())

/**
 * Disassociates user access logging settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateUserAccessLoggingSettings(crossinline block: DisassociateUserAccessLoggingSettingsRequest.Builder.() -> Unit): DisassociateUserAccessLoggingSettingsResponse = disassociateUserAccessLoggingSettings(DisassociateUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Disassociates user settings from a web portal.
 */
public suspend inline fun WorkSpacesWebClient.disassociateUserSettings(crossinline block: DisassociateUserSettingsRequest.Builder.() -> Unit): DisassociateUserSettingsResponse = disassociateUserSettings(DisassociateUserSettingsRequest.Builder().apply(block).build())

/**
 * Expires an active secure browser session.
 */
public suspend inline fun WorkSpacesWebClient.expireSession(crossinline block: ExpireSessionRequest.Builder.() -> Unit): ExpireSessionResponse = expireSession(ExpireSessionRequest.Builder().apply(block).build())

/**
 * Gets browser settings.
 */
public suspend inline fun WorkSpacesWebClient.getBrowserSettings(crossinline block: GetBrowserSettingsRequest.Builder.() -> Unit): GetBrowserSettingsResponse = getBrowserSettings(GetBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Gets the identity provider.
 */
public suspend inline fun WorkSpacesWebClient.getIdentityProvider(crossinline block: GetIdentityProviderRequest.Builder.() -> Unit): GetIdentityProviderResponse = getIdentityProvider(GetIdentityProviderRequest.Builder().apply(block).build())

/**
 * Gets the IP access settings.
 */
public suspend inline fun WorkSpacesWebClient.getIpAccessSettings(crossinline block: GetIpAccessSettingsRequest.Builder.() -> Unit): GetIpAccessSettingsResponse = getIpAccessSettings(GetIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Gets the network settings.
 */
public suspend inline fun WorkSpacesWebClient.getNetworkSettings(crossinline block: GetNetworkSettingsRequest.Builder.() -> Unit): GetNetworkSettingsResponse = getNetworkSettings(GetNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Gets the web portal.
 */
public suspend inline fun WorkSpacesWebClient.getPortal(crossinline block: GetPortalRequest.Builder.() -> Unit): GetPortalResponse = getPortal(GetPortalRequest.Builder().apply(block).build())

/**
 * Gets the service provider metadata.
 */
public suspend inline fun WorkSpacesWebClient.getPortalServiceProviderMetadata(crossinline block: GetPortalServiceProviderMetadataRequest.Builder.() -> Unit): GetPortalServiceProviderMetadataResponse = getPortalServiceProviderMetadata(GetPortalServiceProviderMetadataRequest.Builder().apply(block).build())

/**
 * Gets information for a secure browser session.
 */
public suspend inline fun WorkSpacesWebClient.getSession(crossinline block: GetSessionRequest.Builder.() -> Unit): GetSessionResponse = getSession(GetSessionRequest.Builder().apply(block).build())

/**
 * Gets the trust store.
 */
public suspend inline fun WorkSpacesWebClient.getTrustStore(crossinline block: GetTrustStoreRequest.Builder.() -> Unit): GetTrustStoreResponse = getTrustStore(GetTrustStoreRequest.Builder().apply(block).build())

/**
 * Gets the trust store certificate.
 */
public suspend inline fun WorkSpacesWebClient.getTrustStoreCertificate(crossinline block: GetTrustStoreCertificateRequest.Builder.() -> Unit): GetTrustStoreCertificateResponse = getTrustStoreCertificate(GetTrustStoreCertificateRequest.Builder().apply(block).build())

/**
 * Gets user access logging settings.
 */
public suspend inline fun WorkSpacesWebClient.getUserAccessLoggingSettings(crossinline block: GetUserAccessLoggingSettingsRequest.Builder.() -> Unit): GetUserAccessLoggingSettingsResponse = getUserAccessLoggingSettings(GetUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Gets user settings.
 */
public suspend inline fun WorkSpacesWebClient.getUserSettings(crossinline block: GetUserSettingsRequest.Builder.() -> Unit): GetUserSettingsResponse = getUserSettings(GetUserSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of browser settings.
 */
public suspend inline fun WorkSpacesWebClient.listBrowserSettings(crossinline block: ListBrowserSettingsRequest.Builder.() -> Unit): ListBrowserSettingsResponse = listBrowserSettings(ListBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of identity providers for a specific web portal.
 */
public suspend inline fun WorkSpacesWebClient.listIdentityProviders(crossinline block: ListIdentityProvidersRequest.Builder.() -> Unit): ListIdentityProvidersResponse = listIdentityProviders(ListIdentityProvidersRequest.Builder().apply(block).build())

/**
 * Retrieves a list of IP access settings.
 */
public suspend inline fun WorkSpacesWebClient.listIpAccessSettings(crossinline block: ListIpAccessSettingsRequest.Builder.() -> Unit): ListIpAccessSettingsResponse = listIpAccessSettings(ListIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of network settings.
 */
public suspend inline fun WorkSpacesWebClient.listNetworkSettings(crossinline block: ListNetworkSettingsRequest.Builder.() -> Unit): ListNetworkSettingsResponse = listNetworkSettings(ListNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list or web portals.
 */
public suspend inline fun WorkSpacesWebClient.listPortals(crossinline block: ListPortalsRequest.Builder.() -> Unit): ListPortalsResponse = listPortals(ListPortalsRequest.Builder().apply(block).build())

/**
 * Lists information for multiple secure browser sessions from a specific portal.
 */
public suspend inline fun WorkSpacesWebClient.listSessions(crossinline block: ListSessionsRequest.Builder.() -> Unit): ListSessionsResponse = listSessions(ListSessionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of tags for a resource.
 */
public suspend inline fun WorkSpacesWebClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of trust store certificates.
 */
public suspend inline fun WorkSpacesWebClient.listTrustStoreCertificates(crossinline block: ListTrustStoreCertificatesRequest.Builder.() -> Unit): ListTrustStoreCertificatesResponse = listTrustStoreCertificates(ListTrustStoreCertificatesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of trust stores.
 */
public suspend inline fun WorkSpacesWebClient.listTrustStores(crossinline block: ListTrustStoresRequest.Builder.() -> Unit): ListTrustStoresResponse = listTrustStores(ListTrustStoresRequest.Builder().apply(block).build())

/**
 * Retrieves a list of user access logging settings.
 */
public suspend inline fun WorkSpacesWebClient.listUserAccessLoggingSettings(crossinline block: ListUserAccessLoggingSettingsRequest.Builder.() -> Unit): ListUserAccessLoggingSettingsResponse = listUserAccessLoggingSettings(ListUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of user settings.
 */
public suspend inline fun WorkSpacesWebClient.listUserSettings(crossinline block: ListUserSettingsRequest.Builder.() -> Unit): ListUserSettingsResponse = listUserSettings(ListUserSettingsRequest.Builder().apply(block).build())

/**
 * Adds or overwrites one or more tags for the specified resource.
 */
public suspend inline fun WorkSpacesWebClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun WorkSpacesWebClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates browser settings.
 */
public suspend inline fun WorkSpacesWebClient.updateBrowserSettings(crossinline block: UpdateBrowserSettingsRequest.Builder.() -> Unit): UpdateBrowserSettingsResponse = updateBrowserSettings(UpdateBrowserSettingsRequest.Builder().apply(block).build())

/**
 * Updates the identity provider.
 */
public suspend inline fun WorkSpacesWebClient.updateIdentityProvider(crossinline block: UpdateIdentityProviderRequest.Builder.() -> Unit): UpdateIdentityProviderResponse = updateIdentityProvider(UpdateIdentityProviderRequest.Builder().apply(block).build())

/**
 * Updates IP access settings.
 */
public suspend inline fun WorkSpacesWebClient.updateIpAccessSettings(crossinline block: UpdateIpAccessSettingsRequest.Builder.() -> Unit): UpdateIpAccessSettingsResponse = updateIpAccessSettings(UpdateIpAccessSettingsRequest.Builder().apply(block).build())

/**
 * Updates network settings.
 */
public suspend inline fun WorkSpacesWebClient.updateNetworkSettings(crossinline block: UpdateNetworkSettingsRequest.Builder.() -> Unit): UpdateNetworkSettingsResponse = updateNetworkSettings(UpdateNetworkSettingsRequest.Builder().apply(block).build())

/**
 * Updates a web portal.
 */
public suspend inline fun WorkSpacesWebClient.updatePortal(crossinline block: UpdatePortalRequest.Builder.() -> Unit): UpdatePortalResponse = updatePortal(UpdatePortalRequest.Builder().apply(block).build())

/**
 * Updates the trust store.
 */
public suspend inline fun WorkSpacesWebClient.updateTrustStore(crossinline block: UpdateTrustStoreRequest.Builder.() -> Unit): UpdateTrustStoreResponse = updateTrustStore(UpdateTrustStoreRequest.Builder().apply(block).build())

/**
 * Updates the user access logging settings.
 */
public suspend inline fun WorkSpacesWebClient.updateUserAccessLoggingSettings(crossinline block: UpdateUserAccessLoggingSettingsRequest.Builder.() -> Unit): UpdateUserAccessLoggingSettingsResponse = updateUserAccessLoggingSettings(UpdateUserAccessLoggingSettingsRequest.Builder().apply(block).build())

/**
 * Updates the user settings.
 */
public suspend inline fun WorkSpacesWebClient.updateUserSettings(crossinline block: UpdateUserSettingsRequest.Builder.() -> Unit): UpdateUserSettingsResponse = updateUserSettings(UpdateUserSettingsRequest.Builder().apply(block).build())
