// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspacesweb.model



/**
 * A network settings resource that can be associated with a web portal. Once associated with a web portal, network settings define how streaming instances will connect with your specified VPC.
 */
public class NetworkSettings private constructor(builder: Builder) {
    /**
     * A list of web portal ARNs that this network settings is associated with.
     */
    public val associatedPortalArns: List<String>? = builder.associatedPortalArns
    /**
     * The ARN of the network settings.
     */
    public val networkSettingsArn: kotlin.String = requireNotNull(builder.networkSettingsArn) { "A non-null value must be provided for networkSettingsArn" }
    /**
     * One or more security groups used to control access from streaming instances to your VPC.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The VPC that streaming instances will connect to.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkSettings(")
        append("associatedPortalArns=$associatedPortalArns,")
        append("networkSettingsArn=$networkSettingsArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedPortalArns?.hashCode() ?: 0
        result = 31 * result + (networkSettingsArn.hashCode())
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkSettings

        if (associatedPortalArns != other.associatedPortalArns) return false
        if (networkSettingsArn != other.networkSettingsArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of web portal ARNs that this network settings is associated with.
         */
        public var associatedPortalArns: List<String>? = null
        /**
         * The ARN of the network settings.
         */
        public var networkSettingsArn: kotlin.String? = null
        /**
         * One or more security groups used to control access from streaming instances to your VPC.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of these subnets must be in different availability zones.
         */
        public var subnetIds: List<String>? = null
        /**
         * The VPC that streaming instances will connect to.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings) : this() {
            this.associatedPortalArns = x.associatedPortalArns
            this.networkSettingsArn = x.networkSettingsArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspacesweb.model.NetworkSettings = NetworkSettings(this)

        internal fun correctErrors(): Builder {
            if (networkSettingsArn == null) networkSettingsArn = ""
            return this
        }
    }
}
