// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.services.workspaces.model.ConnectClientAddIn
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectClientAddInsResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeConnectClientAddInsOperationDeserializer: HttpDeserialize<DescribeConnectClientAddInsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeConnectClientAddInsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeConnectClientAddInsError(context, response)
        }
        val builder = DescribeConnectClientAddInsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConnectClientAddInsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeConnectClientAddInsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConnectClientAddInsOperationBody(builder: DescribeConnectClientAddInsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AddIns"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDINS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDINS_DESCRIPTOR.index -> builder.addIns =
                    deserializer.deserializeList(ADDINS_DESCRIPTOR) {
                        val col0 = mutableListOf<ConnectClientAddIn>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConnectClientAddInDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
