// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.transform

import aws.sdk.kotlin.services.workspaces.model.CreateStandbyWorkspacesResponse
import aws.sdk.kotlin.services.workspaces.model.FailedCreateStandbyWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.PendingCreateStandbyWorkspacesRequest
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateStandbyWorkspacesOperationDeserializer: HttpDeserialize<CreateStandbyWorkspacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateStandbyWorkspacesResponse {
        if (!response.status.isSuccess()) {
            throwCreateStandbyWorkspacesError(context, response)
        }
        val builder = CreateStandbyWorkspacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateStandbyWorkspacesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateStandbyWorkspacesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateStandbyWorkspacesOperationBody(builder: CreateStandbyWorkspacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDSTANDBYREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FailedStandbyRequests"))
    val PENDINGSTANDBYREQUESTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PendingStandbyRequests"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDSTANDBYREQUESTS_DESCRIPTOR)
        field(PENDINGSTANDBYREQUESTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDSTANDBYREQUESTS_DESCRIPTOR.index -> builder.failedStandbyRequests =
                    deserializer.deserializeList(FAILEDSTANDBYREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedCreateStandbyWorkspacesRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedCreateStandbyWorkspacesRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PENDINGSTANDBYREQUESTS_DESCRIPTOR.index -> builder.pendingStandbyRequests =
                    deserializer.deserializeList(PENDINGSTANDBYREQUESTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PendingCreateStandbyWorkspacesRequest>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePendingCreateStandbyWorkspacesRequestDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
