// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a WorkSpace image.
 */
public class WorkspaceImage private constructor(builder: Builder) {
    /**
     * The date when the image was created. If the image has been shared, the Amazon Web Services account that the image has been shared with sees the original creation date of the image.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The description of the image.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The error code that is returned for the image.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The text of the error message that is returned for the image.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The identifier of the image.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The name of the image.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The operating system that the image is running.
     */
    public val operatingSystem: aws.sdk.kotlin.services.workspaces.model.OperatingSystem? = builder.operatingSystem
    /**
     * The identifier of the Amazon Web Services account that owns the image.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this value is set to `DEDICATED`. For more information, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
     */
    public val requiredTenancy: aws.sdk.kotlin.services.workspaces.model.WorkspaceImageRequiredTenancy? = builder.requiredTenancy
    /**
     * The status of the image.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.WorkspaceImageState? = builder.state
    /**
     * The updates (if any) that are available for the specified image.
     */
    public val updates: aws.sdk.kotlin.services.workspaces.model.UpdateResult? = builder.updates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceImage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceImage(")
        append("created=$created,")
        append("description=$description,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("imageId=$imageId,")
        append("name=$name,")
        append("operatingSystem=$operatingSystem,")
        append("ownerAccountId=$ownerAccountId,")
        append("requiredTenancy=$requiredTenancy,")
        append("state=$state,")
        append("updates=$updates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = created?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (requiredTenancy?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (updates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceImage

        if (created != other.created) return false
        if (description != other.description) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (imageId != other.imageId) return false
        if (name != other.name) return false
        if (operatingSystem != other.operatingSystem) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (requiredTenancy != other.requiredTenancy) return false
        if (state != other.state) return false
        if (updates != other.updates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceImage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date when the image was created. If the image has been shared, the Amazon Web Services account that the image has been shared with sees the original creation date of the image.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the image.
         */
        public var description: kotlin.String? = null
        /**
         * The error code that is returned for the image.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The text of the error message that is returned for the image.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The identifier of the image.
         */
        public var imageId: kotlin.String? = null
        /**
         * The name of the image.
         */
        public var name: kotlin.String? = null
        /**
         * The operating system that the image is running.
         */
        public var operatingSystem: aws.sdk.kotlin.services.workspaces.model.OperatingSystem? = null
        /**
         * The identifier of the Amazon Web Services account that owns the image.
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this value is set to `DEDICATED`. For more information, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
         */
        public var requiredTenancy: aws.sdk.kotlin.services.workspaces.model.WorkspaceImageRequiredTenancy? = null
        /**
         * The status of the image.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.WorkspaceImageState? = null
        /**
         * The updates (if any) that are available for the specified image.
         */
        public var updates: aws.sdk.kotlin.services.workspaces.model.UpdateResult? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceImage) : this() {
            this.created = x.created
            this.description = x.description
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.imageId = x.imageId
            this.name = x.name
            this.operatingSystem = x.operatingSystem
            this.ownerAccountId = x.ownerAccountId
            this.requiredTenancy = x.requiredTenancy
            this.state = x.state
            this.updates = x.updates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceImage = WorkspaceImage(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.OperatingSystem] inside the given [block]
         */
        public fun operatingSystem(block: aws.sdk.kotlin.services.workspaces.model.OperatingSystem.Builder.() -> kotlin.Unit) {
            this.operatingSystem = aws.sdk.kotlin.services.workspaces.model.OperatingSystem.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.UpdateResult] inside the given [block]
         */
        public fun updates(block: aws.sdk.kotlin.services.workspaces.model.UpdateResult.Builder.() -> kotlin.Unit) {
            this.updates = aws.sdk.kotlin.services.workspaces.model.UpdateResult.invoke(block)
        }
    }
}
