// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a WorkSpace bundle.
 */
public class WorkspaceBundle private constructor(builder: Builder) {
    /**
     * The identifier of the bundle.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The type of WorkSpace bundle.
     */
    public val bundleType: aws.sdk.kotlin.services.workspaces.model.BundleType? = builder.bundleType
    /**
     * The compute type of the bundle. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
     */
    public val computeType: aws.sdk.kotlin.services.workspaces.model.ComputeType? = builder.computeType
    /**
     * The time when the bundle was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the bundle.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the image that was used to create the bundle.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The last time that the bundle was updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The name of the bundle.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the bundle. This is the account identifier of the owner, or `AMAZON` if the bundle is provided by Amazon Web Services.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The size of the root volume.
     */
    public val rootStorage: aws.sdk.kotlin.services.workspaces.model.RootStorage? = builder.rootStorage
    /**
     * The state of the WorkSpace bundle.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.WorkspaceBundleState? = builder.state
    /**
     * The size of the user volume.
     */
    public val userStorage: aws.sdk.kotlin.services.workspaces.model.UserStorage? = builder.userStorage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceBundle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceBundle(")
        append("bundleId=$bundleId,")
        append("bundleType=$bundleType,")
        append("computeType=$computeType,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("imageId=$imageId,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("owner=$owner,")
        append("rootStorage=$rootStorage,")
        append("state=$state,")
        append("userStorage=$userStorage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (bundleType?.hashCode() ?: 0)
        result = 31 * result + (computeType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (rootStorage?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (userStorage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceBundle

        if (bundleId != other.bundleId) return false
        if (bundleType != other.bundleType) return false
        if (computeType != other.computeType) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (imageId != other.imageId) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (rootStorage != other.rootStorage) return false
        if (state != other.state) return false
        if (userStorage != other.userStorage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceBundle = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the bundle.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The type of WorkSpace bundle.
         */
        public var bundleType: aws.sdk.kotlin.services.workspaces.model.BundleType? = null
        /**
         * The compute type of the bundle. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
         */
        public var computeType: aws.sdk.kotlin.services.workspaces.model.ComputeType? = null
        /**
         * The time when the bundle was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the bundle.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the image that was used to create the bundle.
         */
        public var imageId: kotlin.String? = null
        /**
         * The last time that the bundle was updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the bundle.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the bundle. This is the account identifier of the owner, or `AMAZON` if the bundle is provided by Amazon Web Services.
         */
        public var owner: kotlin.String? = null
        /**
         * The size of the root volume.
         */
        public var rootStorage: aws.sdk.kotlin.services.workspaces.model.RootStorage? = null
        /**
         * The state of the WorkSpace bundle.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.WorkspaceBundleState? = null
        /**
         * The size of the user volume.
         */
        public var userStorage: aws.sdk.kotlin.services.workspaces.model.UserStorage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceBundle) : this() {
            this.bundleId = x.bundleId
            this.bundleType = x.bundleType
            this.computeType = x.computeType
            this.creationTime = x.creationTime
            this.description = x.description
            this.imageId = x.imageId
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.owner = x.owner
            this.rootStorage = x.rootStorage
            this.state = x.state
            this.userStorage = x.userStorage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceBundle = WorkspaceBundle(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.ComputeType] inside the given [block]
         */
        public fun computeType(block: aws.sdk.kotlin.services.workspaces.model.ComputeType.Builder.() -> kotlin.Unit) {
            this.computeType = aws.sdk.kotlin.services.workspaces.model.ComputeType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.RootStorage] inside the given [block]
         */
        public fun rootStorage(block: aws.sdk.kotlin.services.workspaces.model.RootStorage.Builder.() -> kotlin.Unit) {
            this.rootStorage = aws.sdk.kotlin.services.workspaces.model.RootStorage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.UserStorage] inside the given [block]
         */
        public fun userStorage(block: aws.sdk.kotlin.services.workspaces.model.UserStorage.Builder.() -> kotlin.Unit) {
            this.userStorage = aws.sdk.kotlin.services.workspaces.model.UserStorage.invoke(block)
        }
    }
}
