// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * The client branding attributes for iOS device types. These attributes are displayed on the iOS client login screen only.
 *
 * Client branding attributes are public facing. Ensure you do not include sensitive information.
 */
public class IosClientBrandingAttributes private constructor(builder: Builder) {
    /**
     * The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.
     */
    public val forgotPasswordLink: kotlin.String? = builder.forgotPasswordLink
    /**
     * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is `en_US`. The HTML tags supported include the following: `a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul`.
     */
    public val loginMessage: Map<String, String>? = builder.loginMessage
    /**
     * The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or @2x). The only image format accepted is a binary data object that is converted from a `.png` file.
     *
     *  For more information about iOS image size and resolution, see [Image Size and Resolution ](https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/) in the *Apple Human Interface Guidelines*.
     */
    public val logo2XUrl: kotlin.String? = builder.logo2XUrl
    /**
     * The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or @3x).The only image format accepted is a binary data object that is converted from a `.png` file.
     *
     *  For more information about iOS image size and resolution, see [Image Size and Resolution ](https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/) in the *Apple Human Interface Guidelines*.
     */
    public val logo3XUrl: kotlin.String? = builder.logo3XUrl
    /**
     * The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel is equal to one point. The only image format accepted is a binary data object that is converted from a `.png` file.
     */
    public val logoUrl: kotlin.String? = builder.logoUrl
    /**
     * The support email. The company's customer support email address.
     *
     * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
     * + The default email is `workspaces-feedback@amazon.com`.
     */
    public val supportEmail: kotlin.String? = builder.supportEmail
    /**
     * The support link. The link for the company's customer support page for their WorkSpace.
     *
     * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
     * + The default support link is `workspaces-feedback@amazon.com`.
     */
    public val supportLink: kotlin.String? = builder.supportLink

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.IosClientBrandingAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IosClientBrandingAttributes(")
        append("forgotPasswordLink=$forgotPasswordLink,")
        append("loginMessage=$loginMessage,")
        append("logo2XUrl=$logo2XUrl,")
        append("logo3XUrl=$logo3XUrl,")
        append("logoUrl=$logoUrl,")
        append("supportEmail=$supportEmail,")
        append("supportLink=$supportLink")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = forgotPasswordLink?.hashCode() ?: 0
        result = 31 * result + (loginMessage?.hashCode() ?: 0)
        result = 31 * result + (logo2XUrl?.hashCode() ?: 0)
        result = 31 * result + (logo3XUrl?.hashCode() ?: 0)
        result = 31 * result + (logoUrl?.hashCode() ?: 0)
        result = 31 * result + (supportEmail?.hashCode() ?: 0)
        result = 31 * result + (supportLink?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IosClientBrandingAttributes

        if (forgotPasswordLink != other.forgotPasswordLink) return false
        if (loginMessage != other.loginMessage) return false
        if (logo2XUrl != other.logo2XUrl) return false
        if (logo3XUrl != other.logo3XUrl) return false
        if (logoUrl != other.logoUrl) return false
        if (supportEmail != other.supportEmail) return false
        if (supportLink != other.supportLink) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.IosClientBrandingAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The forgotten password link. This is the web address that users can go to if they forget the password for their WorkSpace.
         */
        public var forgotPasswordLink: kotlin.String? = null
        /**
         * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized message for that locale. The only key supported is `en_US`. The HTML tags supported include the following: `a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul`.
         */
        public var loginMessage: Map<String, String>? = null
        /**
         * The @2x version of the logo. This is the higher resolution display that offers a scale factor of 2.0 (or @2x). The only image format accepted is a binary data object that is converted from a `.png` file.
         *
         *  For more information about iOS image size and resolution, see [Image Size and Resolution ](https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/) in the *Apple Human Interface Guidelines*.
         */
        public var logo2XUrl: kotlin.String? = null
        /**
         * The @3x version of the logo. This is the higher resolution display that offers a scale factor of 3.0 (or @3x).The only image format accepted is a binary data object that is converted from a `.png` file.
         *
         *  For more information about iOS image size and resolution, see [Image Size and Resolution ](https://developer.apple.com/design/human-interface-guidelines/ios/icons-and-images/image-size-and-resolution/) in the *Apple Human Interface Guidelines*.
         */
        public var logo3XUrl: kotlin.String? = null
        /**
         * The logo. This is the standard-resolution display that has a 1:1 pixel density (or @1x), where one pixel is equal to one point. The only image format accepted is a binary data object that is converted from a `.png` file.
         */
        public var logoUrl: kotlin.String? = null
        /**
         * The support email. The company's customer support email address.
         *
         * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
         * + The default email is `workspaces-feedback@amazon.com`.
         */
        public var supportEmail: kotlin.String? = null
        /**
         * The support link. The link for the company's customer support page for their WorkSpace.
         *
         * + In each platform type, the `SupportEmail` and `SupportLink` parameters are mutually exclusive. You can specify one parameter for each platform type, but not both.
         * + The default support link is `workspaces-feedback@amazon.com`.
         */
        public var supportLink: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.IosClientBrandingAttributes) : this() {
            this.forgotPasswordLink = x.forgotPasswordLink
            this.loginMessage = x.loginMessage
            this.logo2XUrl = x.logo2XUrl
            this.logo3XUrl = x.logo3XUrl
            this.logoUrl = x.logoUrl
            this.supportEmail = x.supportEmail
            this.supportLink = x.supportLink
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.IosClientBrandingAttributes = IosClientBrandingAttributes(this)
    }
}
