// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.DefaultClientBrandingAttributes
import aws.sdk.kotlin.services.workspaces.model.ImportClientBrandingResponse
import aws.sdk.kotlin.services.workspaces.model.IosClientBrandingAttributes
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportClientBrandingOperationDeserializer: HttpDeserializer.NonStreaming<ImportClientBrandingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ImportClientBrandingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwImportClientBrandingError(context, call, payload)
        }
        val builder = ImportClientBrandingResponse.Builder()

        if (payload != null) {
            deserializeImportClientBrandingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwImportClientBrandingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeImportClientBrandingOperationBody(builder: ImportClientBrandingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICETYPEANDROID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceTypeAndroid"))
    val DEVICETYPEIOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceTypeIos"))
    val DEVICETYPELINUX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceTypeLinux"))
    val DEVICETYPEOSX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceTypeOsx"))
    val DEVICETYPEWEB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceTypeWeb"))
    val DEVICETYPEWINDOWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceTypeWindows"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICETYPEANDROID_DESCRIPTOR)
        field(DEVICETYPEIOS_DESCRIPTOR)
        field(DEVICETYPELINUX_DESCRIPTOR)
        field(DEVICETYPEOSX_DESCRIPTOR)
        field(DEVICETYPEWEB_DESCRIPTOR)
        field(DEVICETYPEWINDOWS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICETYPEANDROID_DESCRIPTOR.index -> builder.deviceTypeAndroid = deserializeDefaultClientBrandingAttributesDocument(deserializer)
                DEVICETYPEIOS_DESCRIPTOR.index -> builder.deviceTypeIos = deserializeIosClientBrandingAttributesDocument(deserializer)
                DEVICETYPELINUX_DESCRIPTOR.index -> builder.deviceTypeLinux = deserializeDefaultClientBrandingAttributesDocument(deserializer)
                DEVICETYPEOSX_DESCRIPTOR.index -> builder.deviceTypeOsx = deserializeDefaultClientBrandingAttributesDocument(deserializer)
                DEVICETYPEWEB_DESCRIPTOR.index -> builder.deviceTypeWeb = deserializeDefaultClientBrandingAttributesDocument(deserializer)
                DEVICETYPEWINDOWS_DESCRIPTOR.index -> builder.deviceTypeWindows = deserializeDefaultClientBrandingAttributesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
