// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a modification to the configuration of Bring Your Own License (BYOL) for the specified account.
 */
public class AccountModification private constructor(builder: Builder) {
    /**
     * The IP address range, specified as an IPv4 CIDR block, for the management network interface used for the account.
     */
    public val dedicatedTenancyManagementCidrRange: kotlin.String? = builder.dedicatedTenancyManagementCidrRange
    /**
     * The status of BYOL (whether BYOL is being enabled or disabled).
     */
    public val dedicatedTenancySupport: aws.sdk.kotlin.services.workspaces.model.DedicatedTenancySupportResultEnum? = builder.dedicatedTenancySupport
    /**
     * The error code that is returned if the configuration of BYOL cannot be modified.
     */
    public val errorCode: kotlin.String? = builder.errorCode
    /**
     * The text of the error message that is returned if the configuration of BYOL cannot be modified.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The state of the modification to the configuration of BYOL.
     */
    public val modificationState: aws.sdk.kotlin.services.workspaces.model.DedicatedTenancyModificationStateEnum? = builder.modificationState
    /**
     * The timestamp when the modification of the BYOL configuration was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.AccountModification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountModification(")
        append("dedicatedTenancyManagementCidrRange=$dedicatedTenancyManagementCidrRange,")
        append("dedicatedTenancySupport=$dedicatedTenancySupport,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("modificationState=$modificationState,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dedicatedTenancyManagementCidrRange?.hashCode() ?: 0
        result = 31 * result + (dedicatedTenancySupport?.hashCode() ?: 0)
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (modificationState?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountModification

        if (dedicatedTenancyManagementCidrRange != other.dedicatedTenancyManagementCidrRange) return false
        if (dedicatedTenancySupport != other.dedicatedTenancySupport) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (modificationState != other.modificationState) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.AccountModification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IP address range, specified as an IPv4 CIDR block, for the management network interface used for the account.
         */
        public var dedicatedTenancyManagementCidrRange: kotlin.String? = null
        /**
         * The status of BYOL (whether BYOL is being enabled or disabled).
         */
        public var dedicatedTenancySupport: aws.sdk.kotlin.services.workspaces.model.DedicatedTenancySupportResultEnum? = null
        /**
         * The error code that is returned if the configuration of BYOL cannot be modified.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The text of the error message that is returned if the configuration of BYOL cannot be modified.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The state of the modification to the configuration of BYOL.
         */
        public var modificationState: aws.sdk.kotlin.services.workspaces.model.DedicatedTenancyModificationStateEnum? = null
        /**
         * The timestamp when the modification of the BYOL configuration was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.AccountModification) : this() {
            this.dedicatedTenancyManagementCidrRange = x.dedicatedTenancyManagementCidrRange
            this.dedicatedTenancySupport = x.dedicatedTenancySupport
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.modificationState = x.modificationState
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.AccountModification = AccountModification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
