// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.CustomWorkspaceImageImportErrorDetails
import aws.sdk.kotlin.services.workspaces.model.CustomWorkspaceImageImportState
import aws.sdk.kotlin.services.workspaces.model.DescribeCustomWorkspaceImageImportResponse
import aws.sdk.kotlin.services.workspaces.model.ImageSourceIdentifier
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeCustomWorkspaceImageImportOperationDeserializer: HttpDeserializer.NonStreaming<DescribeCustomWorkspaceImageImportResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeCustomWorkspaceImageImportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCustomWorkspaceImageImportError(context, call, payload)
        }
        val builder = DescribeCustomWorkspaceImageImportResponse.Builder()

        if (payload != null) {
            deserializeDescribeCustomWorkspaceImageImportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeCustomWorkspaceImageImportError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCustomWorkspaceImageImportOperationBody(builder: DescribeCustomWorkspaceImageImportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Created"))
    val ERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ErrorDetails"))
    val IMAGEBUILDERINSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageBuilderInstanceId"))
    val IMAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageId"))
    val IMAGESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImageSource"))
    val INFRASTRUCTURECONFIGURATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InfrastructureConfigurationArn"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATED_DESCRIPTOR)
        field(ERRORDETAILS_DESCRIPTOR)
        field(IMAGEBUILDERINSTANCEID_DESCRIPTOR)
        field(IMAGEID_DESCRIPTOR)
        field(IMAGESOURCE_DESCRIPTOR)
        field(INFRASTRUCTURECONFIGURATIONARN_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATED_DESCRIPTOR.index -> builder.created = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ERRORDETAILS_DESCRIPTOR.index -> builder.errorDetails =
                    deserializer.deserializeList(ERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomWorkspaceImageImportErrorDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomWorkspaceImageImportErrorDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMAGEBUILDERINSTANCEID_DESCRIPTOR.index -> builder.imageBuilderInstanceId = deserializeString()
                IMAGEID_DESCRIPTOR.index -> builder.imageId = deserializeString()
                IMAGESOURCE_DESCRIPTOR.index -> builder.imageSource = deserializeImageSourceIdentifierDocument(deserializer)
                INFRASTRUCTURECONFIGURATIONARN_DESCRIPTOR.index -> builder.infrastructureConfigurationArn = deserializeString()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { CustomWorkspaceImageImportState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
