// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RegisterWorkspaceDirectoryRequest private constructor(builder: Builder) {
    /**
     * The active directory config of the directory.
     */
    public val activeDirectoryConfig: aws.sdk.kotlin.services.workspaces.model.ActiveDirectoryConfig? = builder.activeDirectoryConfig
    /**
     * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * Indicates whether self-service capabilities are enabled or disabled.
     */
    public val enableSelfService: kotlin.Boolean? = builder.enableSelfService
    /**
     * The Amazon Resource Name (ARN) of the identity center instance.
     */
    public val idcInstanceArn: kotlin.String? = builder.idcInstanceArn
    /**
     * The details about Microsoft Entra config.
     */
    public val microsoftEntraConfig: aws.sdk.kotlin.services.workspaces.model.MicrosoftEntraConfig? = builder.microsoftEntraConfig
    /**
     * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags associated with the directory.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to `DEDICATED` and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
     */
    public val tenancy: aws.sdk.kotlin.services.workspaces.model.Tenancy? = builder.tenancy
    /**
     * The type of identity management the user is using.
     */
    public val userIdentityType: aws.sdk.kotlin.services.workspaces.model.UserIdentityType? = builder.userIdentityType
    /**
     * Description of the directory to register.
     */
    public val workspaceDirectoryDescription: kotlin.String? = builder.workspaceDirectoryDescription
    /**
     * The name of the directory to register.
     */
    public val workspaceDirectoryName: kotlin.String? = builder.workspaceDirectoryName
    /**
     * Indicates whether the directory's WorkSpace type is personal or pools.
     */
    public val workspaceType: aws.sdk.kotlin.services.workspaces.model.WorkspaceType? = builder.workspaceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterWorkspaceDirectoryRequest(")
        append("activeDirectoryConfig=$activeDirectoryConfig,")
        append("directoryId=$directoryId,")
        append("enableSelfService=$enableSelfService,")
        append("idcInstanceArn=$idcInstanceArn,")
        append("microsoftEntraConfig=$microsoftEntraConfig,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("tenancy=$tenancy,")
        append("userIdentityType=$userIdentityType,")
        append("workspaceDirectoryDescription=$workspaceDirectoryDescription,")
        append("workspaceDirectoryName=$workspaceDirectoryName,")
        append("workspaceType=$workspaceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryConfig?.hashCode() ?: 0
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (enableSelfService?.hashCode() ?: 0)
        result = 31 * result + (idcInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (microsoftEntraConfig?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        result = 31 * result + (userIdentityType?.hashCode() ?: 0)
        result = 31 * result + (workspaceDirectoryDescription?.hashCode() ?: 0)
        result = 31 * result + (workspaceDirectoryName?.hashCode() ?: 0)
        result = 31 * result + (workspaceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterWorkspaceDirectoryRequest

        if (activeDirectoryConfig != other.activeDirectoryConfig) return false
        if (directoryId != other.directoryId) return false
        if (enableSelfService != other.enableSelfService) return false
        if (idcInstanceArn != other.idcInstanceArn) return false
        if (microsoftEntraConfig != other.microsoftEntraConfig) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (tenancy != other.tenancy) return false
        if (userIdentityType != other.userIdentityType) return false
        if (workspaceDirectoryDescription != other.workspaceDirectoryDescription) return false
        if (workspaceDirectoryName != other.workspaceDirectoryName) return false
        if (workspaceType != other.workspaceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The active directory config of the directory.
         */
        public var activeDirectoryConfig: aws.sdk.kotlin.services.workspaces.model.ActiveDirectoryConfig? = null
        /**
         * The identifier of the directory. You cannot register a directory if it does not have a status of Active. If the directory does not have a status of Active, you will receive an InvalidResourceStateException error. If you have already registered the maximum number of directories that you can register with Amazon WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister directories that you are not using for WorkSpaces, and try again.
         */
        public var directoryId: kotlin.String? = null
        /**
         * Indicates whether self-service capabilities are enabled or disabled.
         */
        public var enableSelfService: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the identity center instance.
         */
        public var idcInstanceArn: kotlin.String? = null
        /**
         * The details about Microsoft Entra config.
         */
        public var microsoftEntraConfig: aws.sdk.kotlin.services.workspaces.model.MicrosoftEntraConfig? = null
        /**
         * The identifiers of the subnets for your virtual private cloud (VPC). Make sure that the subnets are in supported Availability Zones. The subnets must also be in separate Availability Zones. If these conditions are not met, you will receive an OperationNotSupportedException error.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags associated with the directory.
         */
        public var tags: List<Tag>? = null
        /**
         * Indicates whether your WorkSpace directory is dedicated or shared. To use Bring Your Own License (BYOL) images, this value must be set to `DEDICATED` and your Amazon Web Services account must be enabled for BYOL. If your account has not been enabled for BYOL, you will receive an InvalidParameterValuesException error. For more information about BYOL images, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
         */
        public var tenancy: aws.sdk.kotlin.services.workspaces.model.Tenancy? = null
        /**
         * The type of identity management the user is using.
         */
        public var userIdentityType: aws.sdk.kotlin.services.workspaces.model.UserIdentityType? = null
        /**
         * Description of the directory to register.
         */
        public var workspaceDirectoryDescription: kotlin.String? = null
        /**
         * The name of the directory to register.
         */
        public var workspaceDirectoryName: kotlin.String? = null
        /**
         * Indicates whether the directory's WorkSpace type is personal or pools.
         */
        public var workspaceType: aws.sdk.kotlin.services.workspaces.model.WorkspaceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest) : this() {
            this.activeDirectoryConfig = x.activeDirectoryConfig
            this.directoryId = x.directoryId
            this.enableSelfService = x.enableSelfService
            this.idcInstanceArn = x.idcInstanceArn
            this.microsoftEntraConfig = x.microsoftEntraConfig
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.tenancy = x.tenancy
            this.userIdentityType = x.userIdentityType
            this.workspaceDirectoryDescription = x.workspaceDirectoryDescription
            this.workspaceDirectoryName = x.workspaceDirectoryName
            this.workspaceType = x.workspaceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryRequest = RegisterWorkspaceDirectoryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.ActiveDirectoryConfig] inside the given [block]
         */
        public fun activeDirectoryConfig(block: aws.sdk.kotlin.services.workspaces.model.ActiveDirectoryConfig.Builder.() -> kotlin.Unit) {
            this.activeDirectoryConfig = aws.sdk.kotlin.services.workspaces.model.ActiveDirectoryConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.MicrosoftEntraConfig] inside the given [block]
         */
        public fun microsoftEntraConfig(block: aws.sdk.kotlin.services.workspaces.model.MicrosoftEntraConfig.Builder.() -> kotlin.Unit) {
            this.microsoftEntraConfig = aws.sdk.kotlin.services.workspaces.model.MicrosoftEntraConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
