// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.CustomImageProtocol
import aws.sdk.kotlin.services.workspaces.model.ImageComputeType
import aws.sdk.kotlin.services.workspaces.model.ImageSourceIdentifier
import aws.sdk.kotlin.services.workspaces.model.ImportCustomWorkspaceImageRequest
import aws.sdk.kotlin.services.workspaces.model.OsVersion
import aws.sdk.kotlin.services.workspaces.model.Platform
import aws.sdk.kotlin.services.workspaces.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportCustomWorkspaceImageOperationSerializer: HttpSerializer.NonStreaming<ImportCustomWorkspaceImageRequest> {
    override fun serialize(context: ExecutionContext, input: ImportCustomWorkspaceImageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeImportCustomWorkspaceImageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeImportCustomWorkspaceImageOperationBody(context: ExecutionContext, input: ImportCustomWorkspaceImageRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPUTETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ComputeType"))
    val IMAGEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageDescription"))
    val IMAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageName"))
    val IMAGESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImageSource"))
    val INFRASTRUCTURECONFIGURATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InfrastructureConfigurationArn"))
    val OSVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OsVersion"))
    val PLATFORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Platform"))
    val PROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Protocol"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPUTETYPE_DESCRIPTOR)
        field(IMAGEDESCRIPTION_DESCRIPTOR)
        field(IMAGENAME_DESCRIPTOR)
        field(IMAGESOURCE_DESCRIPTOR)
        field(INFRASTRUCTURECONFIGURATIONARN_DESCRIPTOR)
        field(OSVERSION_DESCRIPTOR)
        field(PLATFORM_DESCRIPTOR)
        field(PROTOCOL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.computeType?.let { field(COMPUTETYPE_DESCRIPTOR, it.value) }
        input.imageDescription?.let { field(IMAGEDESCRIPTION_DESCRIPTOR, it) }
        input.imageName?.let { field(IMAGENAME_DESCRIPTOR, it) }
        input.imageSource?.let { field(IMAGESOURCE_DESCRIPTOR, it, ::serializeImageSourceIdentifierDocument) }
        input.infrastructureConfigurationArn?.let { field(INFRASTRUCTURECONFIGURATIONARN_DESCRIPTOR, it) }
        input.osVersion?.let { field(OSVERSION_DESCRIPTOR, it.value) }
        input.platform?.let { field(PLATFORM_DESCRIPTOR, it.value) }
        input.protocol?.let { field(PROTOCOL_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
