// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a pool of WorkSpaces.
 */
public class WorkspacesPool private constructor(builder: Builder) {
    /**
     * The persistent application settings for users of the pool.
     */
    public val applicationSettings: aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse? = builder.applicationSettings
    /**
     * The identifier of the bundle used by the pool.
     */
    public val bundleId: kotlin.String = requireNotNull(builder.bundleId) { "A non-null value must be provided for bundleId" }
    /**
     * The capacity status for the pool
     */
    public val capacityStatus: aws.sdk.kotlin.services.workspaces.model.CapacityStatus? = builder.capacityStatus
    /**
     * The time the pool was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The description of the pool.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the directory used by the pool.
     */
    public val directoryId: kotlin.String = requireNotNull(builder.directoryId) { "A non-null value must be provided for directoryId" }
    /**
     * The pool errors.
     */
    public val errors: List<WorkspacesPoolError>? = builder.errors
    /**
     * The Amazon Resource Name (ARN) for the pool.
     */
    public val poolArn: kotlin.String = requireNotNull(builder.poolArn) { "A non-null value must be provided for poolArn" }
    /**
     * The identifier of a pool.
     */
    public val poolId: kotlin.String = requireNotNull(builder.poolId) { "A non-null value must be provided for poolId" }
    /**
     * The name of the pool.
     */
    public val poolName: kotlin.String = requireNotNull(builder.poolName) { "A non-null value must be provided for poolName" }
    /**
     * The running mode of the pool.
     */
    public val runningMode: aws.sdk.kotlin.services.workspaces.model.PoolsRunningMode = builder.runningMode
    /**
     * The current state of the pool.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.WorkspacesPoolState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
     */
    public val timeoutSettings: aws.sdk.kotlin.services.workspaces.model.TimeoutSettings? = builder.timeoutSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspacesPool = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspacesPool(")
        append("applicationSettings=$applicationSettings,")
        append("bundleId=$bundleId,")
        append("capacityStatus=$capacityStatus,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("directoryId=$directoryId,")
        append("errors=$errors,")
        append("poolArn=$poolArn,")
        append("poolId=$poolId,")
        append("poolName=$poolName,")
        append("runningMode=$runningMode,")
        append("state=$state,")
        append("timeoutSettings=$timeoutSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationSettings?.hashCode() ?: 0
        result = 31 * result + (bundleId.hashCode())
        result = 31 * result + (capacityStatus?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (directoryId.hashCode())
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (poolArn.hashCode())
        result = 31 * result + (poolId.hashCode())
        result = 31 * result + (poolName.hashCode())
        result = 31 * result + (runningMode.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (timeoutSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspacesPool

        if (applicationSettings != other.applicationSettings) return false
        if (bundleId != other.bundleId) return false
        if (capacityStatus != other.capacityStatus) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (directoryId != other.directoryId) return false
        if (errors != other.errors) return false
        if (poolArn != other.poolArn) return false
        if (poolId != other.poolId) return false
        if (poolName != other.poolName) return false
        if (runningMode != other.runningMode) return false
        if (state != other.state) return false
        if (timeoutSettings != other.timeoutSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspacesPool = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The persistent application settings for users of the pool.
         */
        public var applicationSettings: aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse? = null
        /**
         * The identifier of the bundle used by the pool.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The capacity status for the pool
         */
        public var capacityStatus: aws.sdk.kotlin.services.workspaces.model.CapacityStatus? = null
        /**
         * The time the pool was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the pool.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the directory used by the pool.
         */
        public var directoryId: kotlin.String? = null
        /**
         * The pool errors.
         */
        public var errors: List<WorkspacesPoolError>? = null
        /**
         * The Amazon Resource Name (ARN) for the pool.
         */
        public var poolArn: kotlin.String? = null
        /**
         * The identifier of a pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * The name of the pool.
         */
        public var poolName: kotlin.String? = null
        /**
         * The running mode of the pool.
         */
        public var runningMode: aws.sdk.kotlin.services.workspaces.model.PoolsRunningMode = aws.sdk.kotlin.services.workspaces.model.PoolsRunningMode.fromValue("AUTO_STOP")
        /**
         * The current state of the pool.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.WorkspacesPoolState? = null
        /**
         * The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
         */
        public var timeoutSettings: aws.sdk.kotlin.services.workspaces.model.TimeoutSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspacesPool) : this() {
            this.applicationSettings = x.applicationSettings
            this.bundleId = x.bundleId
            this.capacityStatus = x.capacityStatus
            this.createdAt = x.createdAt
            this.description = x.description
            this.directoryId = x.directoryId
            this.errors = x.errors
            this.poolArn = x.poolArn
            this.poolId = x.poolId
            this.poolName = x.poolName
            this.runningMode = x.runningMode
            this.state = x.state
            this.timeoutSettings = x.timeoutSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspacesPool = WorkspacesPool(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse] inside the given [block]
         */
        public fun applicationSettings(block: aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse.Builder.() -> kotlin.Unit) {
            this.applicationSettings = aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.CapacityStatus] inside the given [block]
         */
        public fun capacityStatus(block: aws.sdk.kotlin.services.workspaces.model.CapacityStatus.Builder.() -> kotlin.Unit) {
            this.capacityStatus = aws.sdk.kotlin.services.workspaces.model.CapacityStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.TimeoutSettings] inside the given [block]
         */
        public fun timeoutSettings(block: aws.sdk.kotlin.services.workspaces.model.TimeoutSettings.Builder.() -> kotlin.Unit) {
            this.timeoutSettings = aws.sdk.kotlin.services.workspaces.model.TimeoutSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bundleId == null) bundleId = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (directoryId == null) directoryId = ""
            if (poolArn == null) poolArn = ""
            if (poolId == null) poolId = ""
            if (poolName == null) poolName = ""
            if (state == null) state = WorkspacesPoolState.SdkUnknown("no value provided")
            return this
        }
    }
}
