// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.RegisterWorkspaceDirectoryResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.sdk.kotlin.services.workspaces.model.WorkspaceDirectoryState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterWorkspaceDirectoryOperationDeserializer: HttpDeserializer.NonStreaming<RegisterWorkspaceDirectoryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RegisterWorkspaceDirectoryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRegisterWorkspaceDirectoryError(context, call, payload)
        }
        val builder = RegisterWorkspaceDirectoryResponse.Builder()

        if (payload != null) {
            deserializeRegisterWorkspaceDirectoryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRegisterWorkspaceDirectoryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedNetworkConfigurationException" -> UnsupportedNetworkConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "WorkspacesDefaultRoleNotFoundException" -> WorkspacesDefaultRoleNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidResourceStateException" -> InvalidResourceStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterWorkspaceDirectoryOperationBody(builder: RegisterWorkspaceDirectoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DIRECTORYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DIRECTORYID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DIRECTORYID_DESCRIPTOR.index -> builder.directoryId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { WorkspaceDirectoryState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
