// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes whether a WorkSpace image needs to be updated with the latest drivers and other components required by Amazon WorkSpaces.
 *
 * Only Windows 10 WorkSpace images can be programmatically updated at this time.
 */
public class UpdateResult private constructor(builder: Builder) {
    /**
     * A description of whether updates for the WorkSpace image are pending or available.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether updated drivers or other components are available for the specified WorkSpace image.
     */
    public val updateAvailable: kotlin.Boolean? = builder.updateAvailable

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.UpdateResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResult(")
        append("description=$description,")
        append("updateAvailable=$updateAvailable")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (updateAvailable?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResult

        if (description != other.description) return false
        if (updateAvailable != other.updateAvailable) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.UpdateResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of whether updates for the WorkSpace image are pending or available.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether updated drivers or other components are available for the specified WorkSpace image.
         */
        public var updateAvailable: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.UpdateResult) : this() {
            this.description = x.description
            this.updateAvailable = x.updateAvailable
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.UpdateResult = UpdateResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
