// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the persistent application settings for WorkSpaces Pools users.
 */
public class ApplicationSettingsResponse private constructor(builder: Builder) {
    /**
     * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an Amazon Web Services Region, an S3 bucket is created. The bucket is unique to the Amazon Web Services account and the Region.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The path prefix for the S3 bucket where users’ persistent application settings are stored.
     */
    public val settingsGroup: kotlin.String? = builder.settingsGroup
    /**
     * Specifies whether persistent application settings are enabled for users during their pool sessions.
     */
    public val status: aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsStatusEnum = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSettingsResponse(")
        append("s3BucketName=$s3BucketName,")
        append("settingsGroup=$settingsGroup,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3BucketName?.hashCode() ?: 0
        result = 31 * result + (settingsGroup?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSettingsResponse

        if (s3BucketName != other.s3BucketName) return false
        if (settingsGroup != other.settingsGroup) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an Amazon Web Services Region, an S3 bucket is created. The bucket is unique to the Amazon Web Services account and the Region.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The path prefix for the S3 bucket where users’ persistent application settings are stored.
         */
        public var settingsGroup: kotlin.String? = null
        /**
         * Specifies whether persistent application settings are enabled for users during their pool sessions.
         */
        public var status: aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsStatusEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse) : this() {
            this.s3BucketName = x.s3BucketName
            this.settingsGroup = x.settingsGroup
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.ApplicationSettingsResponse = ApplicationSettingsResponse(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = ApplicationSettingsStatusEnum.SdkUnknown("no value provided")
            return this
        }
    }
}
