// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the timeout settings for a pool of WorkSpaces.
 */
public class TimeoutSettings private constructor(builder: Builder) {
    /**
     * Specifies the amount of time, in seconds, that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within the time set, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
     */
    public val disconnectTimeoutInSeconds: kotlin.Int? = builder.disconnectTimeoutInSeconds
    /**
     * The amount of time in seconds a connection will stay active while idle.
     */
    public val idleDisconnectTimeoutInSeconds: kotlin.Int? = builder.idleDisconnectTimeoutInSeconds
    /**
     * Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
     */
    public val maxUserDurationInSeconds: kotlin.Int? = builder.maxUserDurationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.TimeoutSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeoutSettings(")
        append("disconnectTimeoutInSeconds=$disconnectTimeoutInSeconds,")
        append("idleDisconnectTimeoutInSeconds=$idleDisconnectTimeoutInSeconds,")
        append("maxUserDurationInSeconds=$maxUserDurationInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = disconnectTimeoutInSeconds ?: 0
        result = 31 * result + (idleDisconnectTimeoutInSeconds ?: 0)
        result = 31 * result + (maxUserDurationInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeoutSettings

        if (disconnectTimeoutInSeconds != other.disconnectTimeoutInSeconds) return false
        if (idleDisconnectTimeoutInSeconds != other.idleDisconnectTimeoutInSeconds) return false
        if (maxUserDurationInSeconds != other.maxUserDurationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.TimeoutSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the amount of time, in seconds, that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within the time set, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
         */
        public var disconnectTimeoutInSeconds: kotlin.Int? = null
        /**
         * The amount of time in seconds a connection will stay active while idle.
         */
        public var idleDisconnectTimeoutInSeconds: kotlin.Int? = null
        /**
         * Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
         */
        public var maxUserDurationInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.TimeoutSettings) : this() {
            this.disconnectTimeoutInSeconds = x.disconnectTimeoutInSeconds
            this.idleDisconnectTimeoutInSeconds = x.idleDisconnectTimeoutInSeconds
            this.maxUserDurationInSeconds = x.maxUserDurationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.TimeoutSettings = TimeoutSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
