// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeWorkspacesRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The identifier of the directory. In addition, you can optionally specify a specific directory user (see `UserName`). You cannot combine this parameter with any other filter.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * The maximum number of items to return.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * If you received a `NextToken` from a previous call that was paginated, provide this token to receive the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the directory user. You must specify this parameter with `DirectoryId`.
     */
    public val userName: kotlin.String? = builder.userName
    /**
     * The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.
     *
     * Because the CreateWorkspaces operation is asynchronous, the identifier it returns is not immediately available. If you immediately call DescribeWorkspaces with this identifier, no information is returned.
     */
    public val workspaceIds: List<String>? = builder.workspaceIds
    /**
     * The name of the user-decoupled WorkSpace.
     */
    public val workspaceName: kotlin.String? = builder.workspaceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeWorkspacesRequest(")
        append("bundleId=$bundleId,")
        append("directoryId=$directoryId,")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("userName=$userName,")
        append("workspaceIds=$workspaceIds,")
        append("workspaceName=$workspaceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId?.hashCode() ?: 0
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (workspaceIds?.hashCode() ?: 0)
        result = 31 * result + (workspaceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeWorkspacesRequest

        if (bundleId != other.bundleId) return false
        if (directoryId != other.directoryId) return false
        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (userName != other.userName) return false
        if (workspaceIds != other.workspaceIds) return false
        if (workspaceName != other.workspaceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the bundle. All WorkSpaces that are created from this bundle are retrieved. You cannot combine this parameter with any other filter.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The identifier of the directory. In addition, you can optionally specify a specific directory user (see `UserName`). You cannot combine this parameter with any other filter.
         */
        public var directoryId: kotlin.String? = null
        /**
         * The maximum number of items to return.
         */
        public var limit: kotlin.Int? = null
        /**
         * If you received a `NextToken` from a previous call that was paginated, provide this token to receive the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the directory user. You must specify this parameter with `DirectoryId`.
         */
        public var userName: kotlin.String? = null
        /**
         * The identifiers of the WorkSpaces. You cannot combine this parameter with any other filter.
         *
         * Because the CreateWorkspaces operation is asynchronous, the identifier it returns is not immediately available. If you immediately call DescribeWorkspaces with this identifier, no information is returned.
         */
        public var workspaceIds: List<String>? = null
        /**
         * The name of the user-decoupled WorkSpace.
         */
        public var workspaceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesRequest) : this() {
            this.bundleId = x.bundleId
            this.directoryId = x.directoryId
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.userName = x.userName
            this.workspaceIds = x.workspaceIds
            this.workspaceName = x.workspaceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.DescribeWorkspacesRequest = DescribeWorkspacesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
