// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a pool session.
 */
public class WorkspacesPoolSession private constructor(builder: Builder) {
    /**
     * The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0 federation (SAML).
     */
    public val authenticationType: aws.sdk.kotlin.services.workspaces.model.AuthenticationType? = builder.authenticationType
    /**
     * Specifies whether a user is connected to the pool session.
     */
    public val connectionState: aws.sdk.kotlin.services.workspaces.model.SessionConnectionState? = builder.connectionState
    /**
     * The time that the pool session ended.
     */
    public val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * The identifier for the instance hosting the session.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * Describes the network details of the pool.
     */
    public val networkAccessConfiguration: aws.sdk.kotlin.services.workspaces.model.NetworkAccessConfiguration? = builder.networkAccessConfiguration
    /**
     * The identifier of the pool.
     */
    public val poolId: kotlin.String = requireNotNull(builder.poolId) { "A non-null value must be provided for poolId" }
    /**
     * The identifier of the session.
     */
    public val sessionId: kotlin.String = requireNotNull(builder.sessionId) { "A non-null value must be provided for sessionId" }
    /**
     * The time that the pool sission started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The identifier of the user.
     */
    public val userId: kotlin.String = requireNotNull(builder.userId) { "A non-null value must be provided for userId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspacesPoolSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspacesPoolSession(")
        append("authenticationType=$authenticationType,")
        append("connectionState=$connectionState,")
        append("expirationTime=$expirationTime,")
        append("instanceId=$instanceId,")
        append("networkAccessConfiguration=$networkAccessConfiguration,")
        append("poolId=$poolId,")
        append("sessionId=$sessionId,")
        append("startTime=$startTime,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (connectionState?.hashCode() ?: 0)
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (networkAccessConfiguration?.hashCode() ?: 0)
        result = 31 * result + (poolId.hashCode())
        result = 31 * result + (sessionId.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (userId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspacesPoolSession

        if (authenticationType != other.authenticationType) return false
        if (connectionState != other.connectionState) return false
        if (expirationTime != other.expirationTime) return false
        if (instanceId != other.instanceId) return false
        if (networkAccessConfiguration != other.networkAccessConfiguration) return false
        if (poolId != other.poolId) return false
        if (sessionId != other.sessionId) return false
        if (startTime != other.startTime) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspacesPoolSession = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authentication method. The user is authenticated using a WorkSpaces Pools URL (API) or SAML 2.0 federation (SAML).
         */
        public var authenticationType: aws.sdk.kotlin.services.workspaces.model.AuthenticationType? = null
        /**
         * Specifies whether a user is connected to the pool session.
         */
        public var connectionState: aws.sdk.kotlin.services.workspaces.model.SessionConnectionState? = null
        /**
         * The time that the pool session ended.
         */
        public var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the instance hosting the session.
         */
        public var instanceId: kotlin.String? = null
        /**
         * Describes the network details of the pool.
         */
        public var networkAccessConfiguration: aws.sdk.kotlin.services.workspaces.model.NetworkAccessConfiguration? = null
        /**
         * The identifier of the pool.
         */
        public var poolId: kotlin.String? = null
        /**
         * The identifier of the session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * The time that the pool sission started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the user.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspacesPoolSession) : this() {
            this.authenticationType = x.authenticationType
            this.connectionState = x.connectionState
            this.expirationTime = x.expirationTime
            this.instanceId = x.instanceId
            this.networkAccessConfiguration = x.networkAccessConfiguration
            this.poolId = x.poolId
            this.sessionId = x.sessionId
            this.startTime = x.startTime
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspacesPoolSession = WorkspacesPoolSession(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.NetworkAccessConfiguration] inside the given [block]
         */
        public fun networkAccessConfiguration(block: aws.sdk.kotlin.services.workspaces.model.NetworkAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.networkAccessConfiguration = aws.sdk.kotlin.services.workspaces.model.NetworkAccessConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (poolId == null) poolId = ""
            if (sessionId == null) sessionId = ""
            if (userId == null) userId = ""
            return this
        }
    }
}
