// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the default values that are used to create WorkSpaces. For more information, see [Update Directory Details for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html).
 */
public class DefaultWorkspaceCreationProperties private constructor(builder: Builder) {
    /**
     * The identifier of the default security group to apply to WorkSpaces when they are created. For more information, see [ Security Groups for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html).
     */
    public val customSecurityGroupId: kotlin.String? = builder.customSecurityGroupId
    /**
     * The organizational unit (OU) in the directory for the WorkSpace machine accounts.
     */
    public val defaultOu: kotlin.String? = builder.defaultOu
    /**
     * Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default. If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a Network Address Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information, see [ Configure a VPC for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
     */
    public val enableInternetAccess: kotlin.Boolean? = builder.enableInternetAccess
    /**
     * Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
     */
    public val enableMaintenanceMode: kotlin.Boolean? = builder.enableMaintenanceMode
    /**
     * Specifies whether the directory is enabled for Amazon WorkDocs.
     */
    public val enableWorkDocs: kotlin.Boolean? = builder.enableWorkDocs
    /**
     * Indicates the IAM role ARN of the instance.
     */
    public val instanceIamRoleArn: kotlin.String? = builder.instanceIamRoleArn
    /**
     * Specifies whether WorkSpace users are local administrators on their WorkSpaces.
     */
    public val userEnabledAsLocalAdministrator: kotlin.Boolean? = builder.userEnabledAsLocalAdministrator

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DefaultWorkspaceCreationProperties(")
        append("customSecurityGroupId=$customSecurityGroupId,")
        append("defaultOu=$defaultOu,")
        append("enableInternetAccess=$enableInternetAccess,")
        append("enableMaintenanceMode=$enableMaintenanceMode,")
        append("enableWorkDocs=$enableWorkDocs,")
        append("instanceIamRoleArn=$instanceIamRoleArn,")
        append("userEnabledAsLocalAdministrator=$userEnabledAsLocalAdministrator")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customSecurityGroupId?.hashCode() ?: 0
        result = 31 * result + (defaultOu?.hashCode() ?: 0)
        result = 31 * result + (enableInternetAccess?.hashCode() ?: 0)
        result = 31 * result + (enableMaintenanceMode?.hashCode() ?: 0)
        result = 31 * result + (enableWorkDocs?.hashCode() ?: 0)
        result = 31 * result + (instanceIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (userEnabledAsLocalAdministrator?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DefaultWorkspaceCreationProperties

        if (customSecurityGroupId != other.customSecurityGroupId) return false
        if (defaultOu != other.defaultOu) return false
        if (enableInternetAccess != other.enableInternetAccess) return false
        if (enableMaintenanceMode != other.enableMaintenanceMode) return false
        if (enableWorkDocs != other.enableWorkDocs) return false
        if (instanceIamRoleArn != other.instanceIamRoleArn) return false
        if (userEnabledAsLocalAdministrator != other.userEnabledAsLocalAdministrator) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the default security group to apply to WorkSpaces when they are created. For more information, see [ Security Groups for Your WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html).
         */
        public var customSecurityGroupId: kotlin.String? = null
        /**
         * The organizational unit (OU) in the directory for the WorkSpace machine accounts.
         */
        public var defaultOu: kotlin.String? = null
        /**
         * Specifies whether to automatically assign an Elastic public IP address to WorkSpaces in this directory by default. If enabled, the Elastic public IP address allows outbound internet access from your WorkSpaces when you’re using an internet gateway in the Amazon VPC in which your WorkSpaces are located. If you're using a Network Address Translation (NAT) gateway for outbound internet access from your VPC, or if your WorkSpaces are in public subnets and you manually assign them Elastic IP addresses, you should disable this setting. This setting applies to new WorkSpaces that you launch or to existing WorkSpaces that you rebuild. For more information, see [ Configure a VPC for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
         */
        public var enableInternetAccess: kotlin.Boolean? = null
        /**
         * Specifies whether maintenance mode is enabled for WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
         */
        public var enableMaintenanceMode: kotlin.Boolean? = null
        /**
         * Specifies whether the directory is enabled for Amazon WorkDocs.
         */
        public var enableWorkDocs: kotlin.Boolean? = null
        /**
         * Indicates the IAM role ARN of the instance.
         */
        public var instanceIamRoleArn: kotlin.String? = null
        /**
         * Specifies whether WorkSpace users are local administrators on their WorkSpaces.
         */
        public var userEnabledAsLocalAdministrator: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties) : this() {
            this.customSecurityGroupId = x.customSecurityGroupId
            this.defaultOu = x.defaultOu
            this.enableInternetAccess = x.enableInternetAccess
            this.enableMaintenanceMode = x.enableMaintenanceMode
            this.enableWorkDocs = x.enableWorkDocs
            this.instanceIamRoleArn = x.instanceIamRoleArn
            this.userEnabledAsLocalAdministrator = x.userEnabledAsLocalAdministrator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.DefaultWorkspaceCreationProperties = DefaultWorkspaceCreationProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
