// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes an Amazon WorkSpaces client.
 */
public class ClientProperties private constructor(builder: Builder) {
    /**
     * Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces automatically and will be applied to all users in the specified directory.
     */
    public val logUploadEnabled: aws.sdk.kotlin.services.workspaces.model.LogUploadEnum? = builder.logUploadEnabled
    /**
     * Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can choose to reconnect to their WorkSpaces without re-entering their credentials.
     */
    public val reconnectEnabled: aws.sdk.kotlin.services.workspaces.model.ReconnectEnum? = builder.reconnectEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.ClientProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClientProperties(")
        append("logUploadEnabled=$logUploadEnabled,")
        append("reconnectEnabled=$reconnectEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logUploadEnabled?.hashCode() ?: 0
        result = 31 * result + (reconnectEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClientProperties

        if (logUploadEnabled != other.logUploadEnabled) return false
        if (reconnectEnabled != other.reconnectEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.ClientProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether users can upload diagnostic log files of Amazon WorkSpaces client directly to WorkSpaces to troubleshoot issues when using the WorkSpaces client. When enabled, the log files will be sent to WorkSpaces automatically and will be applied to all users in the specified directory.
         */
        public var logUploadEnabled: aws.sdk.kotlin.services.workspaces.model.LogUploadEnum? = null
        /**
         * Specifies whether users can cache their credentials on the Amazon WorkSpaces client. When enabled, users can choose to reconnect to their WorkSpaces without re-entering their credentials.
         */
        public var reconnectEnabled: aws.sdk.kotlin.services.workspaces.model.ReconnectEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.ClientProperties) : this() {
            this.logUploadEnabled = x.logUploadEnabled
            this.reconnectEnabled = x.reconnectEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.ClientProperties = ClientProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
