// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the capacity status for a pool of WorkSpaces.
 */
public class CapacityStatus private constructor(builder: Builder) {
    /**
     * The number of user sessions currently being used for your pool.
     */
    public val activeUserSessions: kotlin.Int = requireNotNull(builder.activeUserSessions) { "A non-null value must be provided for activeUserSessions" }
    /**
     * The total number of user sessions that are available for streaming or are currently streaming in your pool.
     *
     * ActualUserSessions = AvailableUserSessions + ActiveUserSessions
     */
    public val actualUserSessions: kotlin.Int = requireNotNull(builder.actualUserSessions) { "A non-null value must be provided for actualUserSessions" }
    /**
     * The number of user sessions currently available for streaming from your pool.
     *
     * AvailableUserSessions = ActualUserSessions - ActiveUserSessions
     */
    public val availableUserSessions: kotlin.Int = requireNotNull(builder.availableUserSessions) { "A non-null value must be provided for availableUserSessions" }
    /**
     * The total number of sessions slots that are either running or pending. This represents the total number of concurrent streaming sessions your pool can support in a steady state.
     */
    public val desiredUserSessions: kotlin.Int = requireNotNull(builder.desiredUserSessions) { "A non-null value must be provided for desiredUserSessions" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.CapacityStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityStatus(")
        append("activeUserSessions=$activeUserSessions,")
        append("actualUserSessions=$actualUserSessions,")
        append("availableUserSessions=$availableUserSessions,")
        append("desiredUserSessions=$desiredUserSessions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeUserSessions
        result = 31 * result + (actualUserSessions)
        result = 31 * result + (availableUserSessions)
        result = 31 * result + (desiredUserSessions)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityStatus

        if (activeUserSessions != other.activeUserSessions) return false
        if (actualUserSessions != other.actualUserSessions) return false
        if (availableUserSessions != other.availableUserSessions) return false
        if (desiredUserSessions != other.desiredUserSessions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.CapacityStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of user sessions currently being used for your pool.
         */
        public var activeUserSessions: kotlin.Int? = null
        /**
         * The total number of user sessions that are available for streaming or are currently streaming in your pool.
         *
         * ActualUserSessions = AvailableUserSessions + ActiveUserSessions
         */
        public var actualUserSessions: kotlin.Int? = null
        /**
         * The number of user sessions currently available for streaming from your pool.
         *
         * AvailableUserSessions = ActualUserSessions - ActiveUserSessions
         */
        public var availableUserSessions: kotlin.Int? = null
        /**
         * The total number of sessions slots that are either running or pending. This represents the total number of concurrent streaming sessions your pool can support in a steady state.
         */
        public var desiredUserSessions: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.CapacityStatus) : this() {
            this.activeUserSessions = x.activeUserSessions
            this.actualUserSessions = x.actualUserSessions
            this.availableUserSessions = x.availableUserSessions
            this.desiredUserSessions = x.desiredUserSessions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.CapacityStatus = CapacityStatus(this)

        internal fun correctErrors(): Builder {
            if (activeUserSessions == null) activeUserSessions = 0
            if (actualUserSessions == null) actualUserSessions = 0
            if (availableUserSessions == null) availableUserSessions = 0
            if (desiredUserSessions == null) desiredUserSessions = 0
            return this
        }
    }
}
