// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the association between an application and a bundle resource.
 */
public class BundleResourceAssociation private constructor(builder: Builder) {
    /**
     * The identifier of the associated resource.
     */
    public val associatedResourceId: kotlin.String? = builder.associatedResourceId
    /**
     * The resource type of the associated resources.
     */
    public val associatedResourceType: aws.sdk.kotlin.services.workspaces.model.BundleAssociatedResourceType? = builder.associatedResourceType
    /**
     * The identifier of the bundle.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The time the association is created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The time the association status was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The status of the bundle resource association.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.AssociationState? = builder.state
    /**
     * The reason the association deployment failed.
     */
    public val stateReason: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason? = builder.stateReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.BundleResourceAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BundleResourceAssociation(")
        append("associatedResourceId=$associatedResourceId,")
        append("associatedResourceType=$associatedResourceType,")
        append("bundleId=$bundleId,")
        append("created=$created,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("state=$state,")
        append("stateReason=$stateReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedResourceId?.hashCode() ?: 0
        result = 31 * result + (associatedResourceType?.hashCode() ?: 0)
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BundleResourceAssociation

        if (associatedResourceId != other.associatedResourceId) return false
        if (associatedResourceType != other.associatedResourceType) return false
        if (bundleId != other.bundleId) return false
        if (created != other.created) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.BundleResourceAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the associated resource.
         */
        public var associatedResourceId: kotlin.String? = null
        /**
         * The resource type of the associated resources.
         */
        public var associatedResourceType: aws.sdk.kotlin.services.workspaces.model.BundleAssociatedResourceType? = null
        /**
         * The identifier of the bundle.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The time the association is created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the association status was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the bundle resource association.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.AssociationState? = null
        /**
         * The reason the association deployment failed.
         */
        public var stateReason: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.BundleResourceAssociation) : this() {
            this.associatedResourceId = x.associatedResourceId
            this.associatedResourceType = x.associatedResourceType
            this.bundleId = x.bundleId
            this.created = x.created
            this.lastUpdatedTime = x.lastUpdatedTime
            this.state = x.state
            this.stateReason = x.stateReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.BundleResourceAssociation = BundleResourceAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.AssociationStateReason] inside the given [block]
         */
        public fun stateReason(block: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason.Builder.() -> kotlin.Unit) {
            this.stateReason = aws.sdk.kotlin.services.workspaces.model.AssociationStateReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
