// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.ConnectionAlias
import aws.sdk.kotlin.services.workspaces.model.DescribeConnectionAliasesResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeConnectionAliasesOperationDeserializer: HttpDeserialize<DescribeConnectionAliasesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeConnectionAliasesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeConnectionAliasesError(context, call)
        }
        val builder = DescribeConnectionAliasesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConnectionAliasesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeConnectionAliasesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConnectionAliasesOperationBody(builder: DescribeConnectionAliasesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTIONALIASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConnectionAliases"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONALIASES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTIONALIASES_DESCRIPTOR.index -> builder.connectionAliases =
                    deserializer.deserializeList(CONNECTIONALIASES_DESCRIPTOR) {
                        val col0 = mutableListOf<ConnectionAlias>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConnectionAliasDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
