// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.DedicatedTenancySupportResultEnum
import aws.sdk.kotlin.services.workspaces.model.DescribeAccountResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeAccountOperationDeserializer: HttpDeserialize<DescribeAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeAccountResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAccountError(context, call)
        }
        val builder = DescribeAccountResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeAccountOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeAccountError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAccountOperationBody(builder: DescribeAccountResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEDICATEDTENANCYMANAGEMENTCIDRRANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DedicatedTenancyManagementCidrRange"))
    val DEDICATEDTENANCYSUPPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DedicatedTenancySupport"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEDICATEDTENANCYMANAGEMENTCIDRRANGE_DESCRIPTOR)
        field(DEDICATEDTENANCYSUPPORT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEDICATEDTENANCYMANAGEMENTCIDRRANGE_DESCRIPTOR.index -> builder.dedicatedTenancyManagementCidrRange = deserializeString()
                DEDICATEDTENANCYSUPPORT_DESCRIPTOR.index -> builder.dedicatedTenancySupport = deserializeString().let { DedicatedTenancySupportResultEnum.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
