// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.serde

import aws.sdk.kotlin.services.workspaces.model.AuthorizeIpRulesResponse
import aws.sdk.kotlin.services.workspaces.model.WorkSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AuthorizeIpRulesOperationDeserializer: HttpDeserialize<AuthorizeIpRulesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AuthorizeIpRulesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAuthorizeIpRulesError(context, call)
        }
        val builder = AuthorizeIpRulesResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAuthorizeIpRulesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw WorkSpacesException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValuesException" -> InvalidParameterValuesExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceStateException" -> InvalidResourceStateExceptionDeserializer().deserialize(context, wrappedCall)
        else -> WorkSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
