// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the association between an application and a WorkSpace resource.
 */
public class WorkspaceResourceAssociation private constructor(builder: Builder) {
    /**
     * The identifier of the associated resource.
     */
    public val associatedResourceId: kotlin.String? = builder.associatedResourceId
    /**
     * The resource types of the associated resource.
     */
    public val associatedResourceType: aws.sdk.kotlin.services.workspaces.model.WorkSpaceAssociatedResourceType? = builder.associatedResourceType
    /**
     * The time the association is created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The time the association status was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The status of the WorkSpace resource association.
     */
    public val state: aws.sdk.kotlin.services.workspaces.model.AssociationState? = builder.state
    /**
     * The reason the association deployment failed.
     */
    public val stateReason: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason? = builder.stateReason
    /**
     * The identifier of the WorkSpace.
     */
    public val workspaceId: kotlin.String? = builder.workspaceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceResourceAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceResourceAssociation(")
        append("associatedResourceId=$associatedResourceId,")
        append("associatedResourceType=$associatedResourceType,")
        append("created=$created,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedResourceId?.hashCode() ?: 0
        result = 31 * result + (associatedResourceType?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceResourceAssociation

        if (associatedResourceId != other.associatedResourceId) return false
        if (associatedResourceType != other.associatedResourceType) return false
        if (created != other.created) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceResourceAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the associated resource.
         */
        public var associatedResourceId: kotlin.String? = null
        /**
         * The resource types of the associated resource.
         */
        public var associatedResourceType: aws.sdk.kotlin.services.workspaces.model.WorkSpaceAssociatedResourceType? = null
        /**
         * The time the association is created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the association status was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the WorkSpace resource association.
         */
        public var state: aws.sdk.kotlin.services.workspaces.model.AssociationState? = null
        /**
         * The reason the association deployment failed.
         */
        public var stateReason: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason? = null
        /**
         * The identifier of the WorkSpace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceResourceAssociation) : this() {
            this.associatedResourceId = x.associatedResourceId
            this.associatedResourceType = x.associatedResourceType
            this.created = x.created
            this.lastUpdatedTime = x.lastUpdatedTime
            this.state = x.state
            this.stateReason = x.stateReason
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceResourceAssociation = WorkspaceResourceAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.AssociationStateReason] inside the given [block]
         */
        public fun stateReason(block: aws.sdk.kotlin.services.workspaces.model.AssociationStateReason.Builder.() -> kotlin.Unit) {
            this.stateReason = aws.sdk.kotlin.services.workspaces.model.AssociationStateReason.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
