// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes the information used to create a WorkSpace.
 */
public class WorkspaceRequest private constructor(builder: Builder) {
    /**
     * The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles to list the available bundles.
     */
    public val bundleId: kotlin.String = requireNotNull(builder.bundleId) { "A non-null value must be provided for bundleId" }
    /**
     * The identifier of the Directory Service directory for the WorkSpace. You can use DescribeWorkspaceDirectories to list the available directories.
     */
    public val directoryId: kotlin.String = requireNotNull(builder.directoryId) { "A non-null value must be provided for directoryId" }
    /**
     * Indicates whether the data stored on the root volume is encrypted.
     */
    public val rootVolumeEncryptionEnabled: kotlin.Boolean? = builder.rootVolumeEncryptionEnabled
    /**
     * The tags for the WorkSpace.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The user name of the user for the WorkSpace. This user name must exist in the Directory Service directory for the WorkSpace.
     */
    public val userName: kotlin.String = requireNotNull(builder.userName) { "A non-null value must be provided for userName" }
    /**
     * Indicates whether the data stored on the user volume is encrypted.
     */
    public val userVolumeEncryptionEnabled: kotlin.Boolean? = builder.userVolumeEncryptionEnabled
    /**
     * The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric KMS keys.
     */
    public val volumeEncryptionKey: kotlin.String? = builder.volumeEncryptionKey
    /**
     * The WorkSpace properties.
     */
    public val workspaceProperties: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties? = builder.workspaceProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceRequest(")
        append("bundleId=$bundleId,")
        append("directoryId=$directoryId,")
        append("rootVolumeEncryptionEnabled=$rootVolumeEncryptionEnabled,")
        append("tags=$tags,")
        append("userName=$userName,")
        append("userVolumeEncryptionEnabled=$userVolumeEncryptionEnabled,")
        append("volumeEncryptionKey=$volumeEncryptionKey,")
        append("workspaceProperties=$workspaceProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bundleId.hashCode()
        result = 31 * result + (directoryId.hashCode())
        result = 31 * result + (rootVolumeEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userName.hashCode())
        result = 31 * result + (userVolumeEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (volumeEncryptionKey?.hashCode() ?: 0)
        result = 31 * result + (workspaceProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceRequest

        if (bundleId != other.bundleId) return false
        if (directoryId != other.directoryId) return false
        if (rootVolumeEncryptionEnabled != other.rootVolumeEncryptionEnabled) return false
        if (tags != other.tags) return false
        if (userName != other.userName) return false
        if (userVolumeEncryptionEnabled != other.userVolumeEncryptionEnabled) return false
        if (volumeEncryptionKey != other.volumeEncryptionKey) return false
        if (workspaceProperties != other.workspaceProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles to list the available bundles.
         */
        public var bundleId: kotlin.String? = null
        /**
         * The identifier of the Directory Service directory for the WorkSpace. You can use DescribeWorkspaceDirectories to list the available directories.
         */
        public var directoryId: kotlin.String? = null
        /**
         * Indicates whether the data stored on the root volume is encrypted.
         */
        public var rootVolumeEncryptionEnabled: kotlin.Boolean? = null
        /**
         * The tags for the WorkSpace.
         */
        public var tags: List<Tag>? = null
        /**
         * The user name of the user for the WorkSpace. This user name must exist in the Directory Service directory for the WorkSpace.
         */
        public var userName: kotlin.String? = null
        /**
         * Indicates whether the data stored on the user volume is encrypted.
         */
        public var userVolumeEncryptionEnabled: kotlin.Boolean? = null
        /**
         * The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric KMS keys.
         */
        public var volumeEncryptionKey: kotlin.String? = null
        /**
         * The WorkSpace properties.
         */
        public var workspaceProperties: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceRequest) : this() {
            this.bundleId = x.bundleId
            this.directoryId = x.directoryId
            this.rootVolumeEncryptionEnabled = x.rootVolumeEncryptionEnabled
            this.tags = x.tags
            this.userName = x.userName
            this.userVolumeEncryptionEnabled = x.userVolumeEncryptionEnabled
            this.volumeEncryptionKey = x.volumeEncryptionKey
            this.workspaceProperties = x.workspaceProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceRequest = WorkspaceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties] inside the given [block]
         */
        public fun workspaceProperties(block: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties.Builder.() -> kotlin.Unit) {
            this.workspaceProperties = aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bundleId == null) bundleId = ""
            if (directoryId == null) directoryId = ""
            if (userName == null) userName = ""
            return this
        }
    }
}
