// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes a WorkSpace.
 */
public class WorkspaceProperties private constructor(builder: Builder) {
    /**
     * The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
     */
    public val computeTypeName: aws.sdk.kotlin.services.workspaces.model.Compute? = builder.computeTypeName
    /**
     * The name of the operating system.
     */
    public val operatingSystemName: aws.sdk.kotlin.services.workspaces.model.OperatingSystemName? = builder.operatingSystemName
    /**
     * The protocol. For more information, see [ Protocols for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-protocols.html).
     *
     * + Only available for WorkSpaces created with PCoIP bundles.
     * + The `Protocols` property is case sensitive. Ensure you use `PCOIP` or `WSP`.
     * + Unavailable for Windows 7 WorkSpaces and WorkSpaces using GPU-based bundles (Graphics, GraphicsPro, Graphics.g4dn, and GraphicsPro.g4dn).
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * The size of the root volume. For important information about how to modify the size of the root and user volumes, see [Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
     */
    public val rootVolumeSizeGib: kotlin.Int? = builder.rootVolumeSizeGib
    /**
     * The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
     *
     * The `MANUAL` value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
     */
    public val runningMode: aws.sdk.kotlin.services.workspaces.model.RunningMode? = builder.runningMode
    /**
     * The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
     */
    public val runningModeAutoStopTimeoutInMinutes: kotlin.Int? = builder.runningModeAutoStopTimeoutInMinutes
    /**
     * The size of the user storage. For important information about how to modify the size of the root and user volumes, see [Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
     */
    public val userVolumeSizeGib: kotlin.Int? = builder.userVolumeSizeGib

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceProperties(")
        append("computeTypeName=$computeTypeName,")
        append("operatingSystemName=$operatingSystemName,")
        append("protocols=$protocols,")
        append("rootVolumeSizeGib=$rootVolumeSizeGib,")
        append("runningMode=$runningMode,")
        append("runningModeAutoStopTimeoutInMinutes=$runningModeAutoStopTimeoutInMinutes,")
        append("userVolumeSizeGib=$userVolumeSizeGib")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeTypeName?.hashCode() ?: 0
        result = 31 * result + (operatingSystemName?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (rootVolumeSizeGib ?: 0)
        result = 31 * result + (runningMode?.hashCode() ?: 0)
        result = 31 * result + (runningModeAutoStopTimeoutInMinutes ?: 0)
        result = 31 * result + (userVolumeSizeGib ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceProperties

        if (computeTypeName != other.computeTypeName) return false
        if (operatingSystemName != other.operatingSystemName) return false
        if (protocols != other.protocols) return false
        if (rootVolumeSizeGib != other.rootVolumeSizeGib) return false
        if (runningMode != other.runningMode) return false
        if (runningModeAutoStopTimeoutInMinutes != other.runningModeAutoStopTimeoutInMinutes) return false
        if (userVolumeSizeGib != other.userVolumeSizeGib) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
         */
        public var computeTypeName: aws.sdk.kotlin.services.workspaces.model.Compute? = null
        /**
         * The name of the operating system.
         */
        public var operatingSystemName: aws.sdk.kotlin.services.workspaces.model.OperatingSystemName? = null
        /**
         * The protocol. For more information, see [ Protocols for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-protocols.html).
         *
         * + Only available for WorkSpaces created with PCoIP bundles.
         * + The `Protocols` property is case sensitive. Ensure you use `PCOIP` or `WSP`.
         * + Unavailable for Windows 7 WorkSpaces and WorkSpaces using GPU-based bundles (Graphics, GraphicsPro, Graphics.g4dn, and GraphicsPro.g4dn).
         */
        public var protocols: List<Protocol>? = null
        /**
         * The size of the root volume. For important information about how to modify the size of the root and user volumes, see [Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
         */
        public var rootVolumeSizeGib: kotlin.Int? = null
        /**
         * The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
         *
         * The `MANUAL` value is only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more information, see [Amazon WorkSpaces Core](http://aws.amazon.com/workspaces/core/).
         */
        public var runningMode: aws.sdk.kotlin.services.workspaces.model.RunningMode? = null
        /**
         * The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
         */
        public var runningModeAutoStopTimeoutInMinutes: kotlin.Int? = null
        /**
         * The size of the user storage. For important information about how to modify the size of the root and user volumes, see [Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
         */
        public var userVolumeSizeGib: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties) : this() {
            this.computeTypeName = x.computeTypeName
            this.operatingSystemName = x.operatingSystemName
            this.protocols = x.protocols
            this.rootVolumeSizeGib = x.rootVolumeSizeGib
            this.runningMode = x.runningMode
            this.runningModeAutoStopTimeoutInMinutes = x.runningModeAutoStopTimeoutInMinutes
            this.userVolumeSizeGib = x.userVolumeSizeGib
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.WorkspaceProperties = WorkspaceProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
