// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.workspaces.model



/**
 * Describes the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
 */
public class SamlProperties private constructor(builder: Builder) {
    /**
     * The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is redirected to the user access URL from the WorkSpaces client application, this relay state parameter name is appended as a query parameter to the URL along with the relay state endpoint to return the user to the client application session.
     *
     * To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for the relay state URL. Consult your IdP documentation for more information.
     */
    public val relayStateParameterName: kotlin.String? = builder.relayStateParameterName
    /**
     * Indicates the status of SAML 2.0 authentication. These statuses include the following.
     * + If the setting is `DISABLED`, end users will be directed to login with their directory credentials.
     * + If the setting is `ENABLED`, end users will be directed to login via the user access URL. Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication will not be able to connect.
     * + If the setting is `ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK`, end users will be directed to login via the user access URL on supported client applications, but will not prevent clients that do not support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
     */
    public val status: aws.sdk.kotlin.services.workspaces.model.SamlStatusEnum? = builder.status
    /**
     * The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web browser in order to federate from the IdP and directly access the application, without any SAML 2.0 service provider (SP) bindings.
     */
    public val userAccessUrl: kotlin.String? = builder.userAccessUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.workspaces.model.SamlProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SamlProperties(")
        append("relayStateParameterName=$relayStateParameterName,")
        append("status=$status,")
        append("userAccessUrl=$userAccessUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = relayStateParameterName?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userAccessUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SamlProperties

        if (relayStateParameterName != other.relayStateParameterName) return false
        if (status != other.status) return false
        if (userAccessUrl != other.userAccessUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.workspaces.model.SamlProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The relay state parameter name supported by the SAML 2.0 identity provider (IdP). When the end user is redirected to the user access URL from the WorkSpaces client application, this relay state parameter name is appended as a query parameter to the URL along with the relay state endpoint to return the user to the client application session.
         *
         * To use SAML 2.0 authentication with WorkSpaces, the IdP must support IdP-initiated deep linking for the relay state URL. Consult your IdP documentation for more information.
         */
        public var relayStateParameterName: kotlin.String? = null
        /**
         * Indicates the status of SAML 2.0 authentication. These statuses include the following.
         * + If the setting is `DISABLED`, end users will be directed to login with their directory credentials.
         * + If the setting is `ENABLED`, end users will be directed to login via the user access URL. Users attempting to connect to WorkSpaces from a client application that does not support SAML 2.0 authentication will not be able to connect.
         * + If the setting is `ENABLED_WITH_DIRECTORY_LOGIN_FALLBACK`, end users will be directed to login via the user access URL on supported client applications, but will not prevent clients that do not support SAML 2.0 authentication from connecting as if SAML 2.0 authentication was disabled.
         */
        public var status: aws.sdk.kotlin.services.workspaces.model.SamlStatusEnum? = null
        /**
         * The SAML 2.0 identity provider (IdP) user access URL is the URL a user would navigate to in their web browser in order to federate from the IdP and directly access the application, without any SAML 2.0 service provider (SP) bindings.
         */
        public var userAccessUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.workspaces.model.SamlProperties) : this() {
            this.relayStateParameterName = x.relayStateParameterName
            this.status = x.status
            this.userAccessUrl = x.userAccessUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.workspaces.model.SamlProperties = SamlProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
